/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.trainstopcriterion;

import adams.core.Index;
import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.DL4JModelContainer;
import adams.ml.dl4j.EvaluationHelper;
import adams.ml.dl4j.EvaluationStatistic;
import adams.ml.dl4j.trainstopcriterion.AbstractTrainStopCriterion;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.eval.RegressionEvaluation;

public class NoImprovement
extends AbstractTrainStopCriterion {
    private static final long serialVersionUID = 6975594226423139162L;
    protected EvaluationStatistic[] m_Statistics;
    protected Index m_ClassIndex;
    protected Index m_RegressionColumns;
    protected Map<EvaluationStatistic, Double> m_History;

    public String globalInfo() {
        return "Monitors one or more statistics, whether they improve at all over time.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statistics", (Object)new EvaluationStatistic[]{EvaluationStatistic.ACCURACY});
        this.m_OptionManager.add("index", "classIndex", (Object)new Index("first"));
        this.m_OptionManager.add("regression-columns", "regressionColumns", (Object)new Index("last"));
    }

    public void setStatistics(EvaluationStatistic[] value) {
        this.m_Statistics = value;
        this.reset();
    }

    public EvaluationStatistic[] getStatistics() {
        return this.m_Statistics;
    }

    public String statisticsTipText() {
        return "The statistics to monitor.";
    }

    public void setClassIndex(Index value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public Index getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The range of class label indices (eg used for AUC).";
    }

    public void setRegressionColumns(Index value) {
        this.m_RegressionColumns = value;
        this.reset();
    }

    public Index getRegressionColumns() {
        return this.m_RegressionColumns;
    }

    public String regressionColumnsTipText() {
        return "The range of columns to get regression statistics for.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"statistics", (Object)(this.m_Statistics.length + " statistic" + (this.m_Statistics.length == 1 ? "" : "s")));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"classIndex", (Object)this.m_ClassIndex, (String)", class labels: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"regressionColumns", (Object)this.m_RegressionColumns, (String)", reg cols: ");
        return result;
    }

    @Override
    public void start() {
        super.start();
        this.m_History = new HashMap<EvaluationStatistic, Double>();
    }

    @Override
    public boolean requiresFlowContext() {
        return false;
    }

    @Override
    protected boolean doCheckStopping(DL4JModelContainer cont, MessageCollection triggers) {
        if (!cont.hasValue("Evaluation")) {
            return false;
        }
        Object eval = cont.getValue("Evaluation");
        boolean result = true;
        for (EvaluationStatistic stat : this.m_Statistics) {
            try {
                double value;
                if (eval instanceof Evaluation) {
                    Evaluation evalCls = (Evaluation)eval;
                    this.m_ClassIndex.setMax(evalCls.falseNegatives().size());
                    value = EvaluationHelper.getValue(evalCls, stat, this.m_ClassIndex.getIntIndex());
                } else if (eval instanceof RegressionEvaluation) {
                    RegressionEvaluation evalReg = (RegressionEvaluation)eval;
                    this.m_RegressionColumns.setMax(evalReg.numColumns());
                    value = EvaluationHelper.getValue(evalReg, stat, this.m_RegressionColumns.getIntIndex());
                } else {
                    throw new IllegalStateException("Unhandled evaluation class: " + eval.getClass().getName());
                }
                if (this.m_History.isEmpty()) {
                    result = false;
                } else if (this.m_History.get((Object)stat) != value) {
                    result = false;
                }
                if (result) continue;
                this.m_History.put(stat, value);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to obtain statistic " + (Object)((Object)stat) + " from " + eval.getClass().getName() + " object!", (Throwable)e);
                result = false;
            }
        }
        if (this.isLoggingEnabled()) {
            if (result) {
                this.getLogger().info("No improvement: " + this.m_History);
            } else {
                this.getLogger().fine("Change: " + this.m_History);
            }
        }
        return result;
    }
}

