/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.trainstopcriterion;

import adams.core.Index;
import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.DL4JModelContainer;
import adams.ml.dl4j.EvaluationHelper;
import adams.ml.dl4j.EvaluationStatistic;
import adams.ml.dl4j.trainstopcriterion.AbstractTrainStopCriterion;
import java.util.logging.Level;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.eval.RegressionEvaluation;

public class Statistic
extends AbstractTrainStopCriterion {
    private static final long serialVersionUID = 6975594226423139162L;
    protected EvaluationStatistic m_Statistic;
    protected Index m_ClassIndex;
    protected Index m_RegressionColumns;
    protected double m_Threshold;
    protected ThresholdCheck m_ThresholdCheck;

    public String globalInfo() {
        return "Monitors a statistic, whether it goes below or above a threshold.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statistic", (Object)EvaluationStatistic.ACCURACY);
        this.m_OptionManager.add("index", "classIndex", (Object)new Index("first"));
        this.m_OptionManager.add("regression-columns", "regressionColumns", (Object)new Index("last"));
        this.m_OptionManager.add("threshold", "threshold", (Object)0.9);
        this.m_OptionManager.add("threshold-check", "thresholdCheck", (Object)ThresholdCheck.GREATER_OR_EQUAL);
    }

    public void setStatistic(EvaluationStatistic value) {
        this.m_Statistic = value;
        this.reset();
    }

    public EvaluationStatistic getStatistic() {
        return this.m_Statistic;
    }

    public String statisticTipText() {
        return "The name of the variable to monitor.";
    }

    public void setClassIndex(Index value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public Index getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The range of class label indices (eg used for AUC).";
    }

    public void setRegressionColumns(Index value) {
        this.m_RegressionColumns = value;
        this.reset();
    }

    public Index getRegressionColumns() {
        return this.m_RegressionColumns;
    }

    public String regressionColumnsTipText() {
        return "The range of columns to get regression statistics for.";
    }

    public void setThreshold(double value) {
        this.m_Threshold = value;
        this.reset();
    }

    public double getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold for the statistic.";
    }

    public void setThresholdCheck(ThresholdCheck value) {
        this.m_ThresholdCheck = value;
        this.reset();
    }

    public ThresholdCheck getThresholdCheck() {
        return this.m_ThresholdCheck;
    }

    public String thresholdCheckTipText() {
        return "Determines how to interpret the threshold.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"statistic", (Object)((Object)this.m_Statistic));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"thresholdCheck", (Object)((Object)this.m_ThresholdCheck), (String)" ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"threshold", (Object)this.m_Threshold, (String)" ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"classIndex", (Object)this.m_ClassIndex, (String)", class labels: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"regressionColumns", (Object)this.m_RegressionColumns, (String)", reg cols: ");
        return result;
    }

    @Override
    public boolean requiresFlowContext() {
        return false;
    }

    @Override
    protected boolean doCheckStopping(DL4JModelContainer cont, MessageCollection triggers) {
        boolean result;
        if (!cont.hasValue("Evaluation")) {
            return false;
        }
        Object eval = cont.getValue("Evaluation");
        double stat = Double.NaN;
        try {
            if (eval instanceof Evaluation) {
                Evaluation evalCls = (Evaluation)eval;
                this.m_ClassIndex.setMax(evalCls.falseNegatives().size());
                stat = EvaluationHelper.getValue(evalCls, this.m_Statistic, this.m_ClassIndex.getIntIndex());
            } else if (eval instanceof RegressionEvaluation) {
                RegressionEvaluation evalReg = (RegressionEvaluation)eval;
                this.m_RegressionColumns.setMax(evalReg.numColumns());
                stat = EvaluationHelper.getValue(evalReg, this.m_Statistic, this.m_RegressionColumns.getIntIndex());
            } else {
                throw new IllegalStateException("Unhandled evaluation class: " + eval.getClass().getName());
            }
            switch (this.m_ThresholdCheck) {
                case GREATER: {
                    result = stat > this.m_Threshold;
                    break;
                }
                case GREATER_OR_EQUAL: {
                    result = stat >= this.m_Threshold;
                    break;
                }
                case LESS: {
                    result = stat < this.m_Threshold;
                    break;
                }
                case LESS_OR_EQUAL: {
                    result = stat <= this.m_Threshold;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled threshold check: " + (Object)((Object)this.m_ThresholdCheck));
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to obtain statistic " + (Object)((Object)this.m_Statistic) + " from " + eval.getClass().getName() + " object!", (Throwable)e);
            result = false;
        }
        if (result && this.isLoggingEnabled()) {
            this.getLogger().info((Object)((Object)this.m_Statistic) + ": " + stat + " " + (Object)((Object)this.m_ThresholdCheck) + " " + this.m_Threshold);
        }
        return result;
    }

    public static enum ThresholdCheck {
        GREATER_OR_EQUAL,
        GREATER,
        LESS,
        LESS_OR_EQUAL;

    }
}

