/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseString;
import adams.core.io.PlaceholderDirectory;
import java.io.File;

public class DockerDirectoryMapping
extends AbstractBaseString {
    private static final long serialVersionUID = 9003132865953252981L;

    public DockerDirectoryMapping() {
        this("/local:/container");
    }

    public DockerDirectoryMapping(String mapping) {
        super(DockerDirectoryMapping.collapseLocalDir(mapping));
    }

    public DockerDirectoryMapping(File localDir, File containerDir) {
        this(new PlaceholderDirectory(localDir).toString(), containerDir.getAbsolutePath());
    }

    public DockerDirectoryMapping(String localDir, String containerDir) {
        this(new PlaceholderDirectory(localDir) + ":" + containerDir);
    }

    public boolean isValid(String value) {
        boolean result = value.contains(":");
        if (result) {
            String[] parts = value.split(":");
            result = parts.length == 2;
        }
        return result;
    }

    public String localDir() {
        return new PlaceholderDirectory(this.getValue().split(":")[0]).getAbsolutePath();
    }

    public String containerDir() {
        return this.getValue().split(":")[1];
    }

    public String getExpandedValue() {
        return this.localDir() + ":" + this.containerDir();
    }

    public String getTipText() {
        return "For mapping a host directory into a container, format: <abs. local dir>:<abs. container dir>";
    }

    public static String collapseLocalDir(String mapping) {
        if (!mapping.contains(":") || mapping.split(":").length != 2) {
            return mapping;
        }
        String[] parts = mapping.split(":");
        return new PlaceholderDirectory(parts[0]) + ":" + parts[1];
    }
}

