/*
 * Decompiled with CFR 0.152.
 */
package adams.docker;

import adams.core.base.DockerDirectoryMapping;
import adams.core.logging.LoggingHelper;
import adams.core.management.CommandResult;
import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class SimpleDockerHelper {
    public static CommandResult login(String binary, String registry, String user, String pw) {
        CommandResult result;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(binary);
        cmd.add("login");
        if (user != null && !user.isEmpty()) {
            cmd.add("-u");
            cmd.add(user);
            if (pw != null && !pw.isEmpty()) {
                cmd.add("--password-stdin");
            }
        }
        if (registry != null && !registry.isEmpty()) {
            cmd.add(registry);
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(cmd);
        try {
            CollectingProcessOutput output = new CollectingProcessOutput();
            if (pw != null && !pw.isEmpty()) {
                output.monitor(pw, builder);
            } else {
                output.monitor(builder);
            }
            result = new CommandResult(cmd.toArray(new String[0]), output.getExitCode(), output.getStdOut(), output.getStdErr());
        }
        catch (Exception e) {
            result = new CommandResult(cmd.toArray(new String[0]), 1, null, "Failed to login:\n" + LoggingHelper.throwableToString((Throwable)e));
        }
        return result;
    }

    public static CommandResult logout(String binary, String registry) {
        CommandResult result;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(binary);
        cmd.add("logout");
        if (registry != null && !registry.isEmpty()) {
            cmd.add(registry);
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(cmd);
        try {
            CollectingProcessOutput output = new CollectingProcessOutput();
            output.monitor(builder);
            result = new CommandResult(cmd.toArray(new String[0]), output.getExitCode(), output.getStdOut(), output.getStdErr());
        }
        catch (Exception e) {
            result = new CommandResult(cmd.toArray(new String[0]), 1, null, "Failed to logout:\n" + LoggingHelper.throwableToString((Throwable)e));
        }
        return result;
    }

    public static CommandResult command(String binary, String[] command) {
        return SimpleDockerHelper.command(binary, Arrays.asList(command));
    }

    public static CommandResult command(String binary, List<String> command) {
        CommandResult result;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(binary);
        cmd.addAll(command);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(cmd);
        try {
            CollectingProcessOutput output = new CollectingProcessOutput();
            output.monitor(builder);
            result = new CommandResult(cmd.toArray(new String[0]), output.getExitCode(), output.getStdOut(), output.getStdErr());
        }
        catch (Exception e) {
            result = new CommandResult(cmd.toArray(new String[0]), 1, null, "Failed to execute docker command:\n" + LoggingHelper.throwableToString((Throwable)e));
        }
        return result;
    }

    public static String fixPath(String path) {
        String result = path;
        while (result.contains("//")) {
            result = result.replace("//", "/");
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String toContainerPath(List<DockerDirectoryMapping> mappings, String path) throws IOException {
        return SimpleDockerHelper.toContainerPaths(mappings, new String[]{path})[0];
    }

    public static String[] toContainerPaths(List<DockerDirectoryMapping> mappings, String[] paths) throws IOException {
        String[] result = new String[paths.length];
        ArrayList<DockerDirectoryMapping> sorted = new ArrayList<DockerDirectoryMapping>(mappings);
        sorted.sort(new Comparator<DockerDirectoryMapping>(){

            @Override
            public int compare(DockerDirectoryMapping o1, DockerDirectoryMapping o2) {
                return o1.length() - o2.length();
            }
        });
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].startsWith("/")) {
                Path path = new File(paths[i]).toPath();
                result[i] = null;
                for (DockerDirectoryMapping mapping : sorted) {
                    if (!path.startsWith(mapping.localDir())) continue;
                    result[i] = SimpleDockerHelper.fixPath(mapping.containerDir() + "/" + paths[i].substring(Math.min(paths[i].length(), mapping.localDir().length())));
                    break;
                }
            } else {
                result[i] = paths[i];
            }
            if (result[i] != null) continue;
            throw new IOException("Failed to translate local path '" + paths[i] + "' into container one using: " + mappings);
        }
        return result;
    }

    public static String canAddMapping(List<DockerDirectoryMapping> mappings, DockerDirectoryMapping newMapping) {
        String result = null;
        HashMap<File, DockerDirectoryMapping> dirs = new HashMap<File, DockerDirectoryMapping>();
        for (DockerDirectoryMapping m : mappings) {
            dirs.put(new File(m.localDir()), m);
        }
        File f = new File(newMapping.localDir());
        if (dirs.containsKey(f)) {
            result = "Local directory already defined by: " + dirs.get(f);
        }
        if (result == null) {
            dirs = new HashMap();
            for (DockerDirectoryMapping m : mappings) {
                dirs.put(new File(m.containerDir()), m);
            }
            f = new File(newMapping.containerDir());
            if (dirs.containsKey(f)) {
                result = "Container directory already defined by: " + dirs.get(f);
            }
        }
        return result;
    }

    public static boolean addMapping(List<DockerDirectoryMapping> mappings, DockerDirectoryMapping newMapping) {
        if (SimpleDockerHelper.canAddMapping(mappings, newMapping) == null) {
            mappings.add(newMapping);
            return true;
        }
        return false;
    }
}

