/*
 * Decompiled with CFR 0.152.
 */
package adams.docker.simpledocker;

import adams.core.Utils;
import adams.core.command.AbstractAsyncCapableExternalCommandWithOptions;
import adams.core.management.CommandResult;
import adams.docker.SimpleDockerHelper;
import adams.docker.simpledocker.DockerCommand;
import adams.flow.standalone.SimpleDockerConnection;
import java.util.List;

public abstract class AbstractDockerCommandWithOptions
extends AbstractAsyncCapableExternalCommandWithOptions
implements DockerCommand {
    private static final long serialVersionUID = 7898785828472200774L;
    protected transient SimpleDockerConnection m_Connection;

    @Override
    public void setConnection(SimpleDockerConnection value) {
        this.m_Connection = value;
    }

    @Override
    public SimpleDockerConnection getConnection() {
        return this.m_Connection;
    }

    protected String check() {
        Object result = super.check();
        if (result == null && this.m_Connection == null) {
            result = "No docker connection available! Missing " + Utils.classToString(SimpleDockerConnection.class) + " standalone?";
        }
        return result;
    }

    protected List<String> buildCommand() {
        List result = super.buildCommand();
        if (!this.isUsingBlocking()) {
            result.add(this.m_Connection.getAcualBinary());
        }
        return result;
    }

    protected CommandResult doBlockingExecute(List<String> cmd) {
        this.log(cmd);
        this.m_LastCommand = cmd.toArray(new String[0]);
        return SimpleDockerHelper.command(this.m_Connection.getAcualBinary(), cmd);
    }

    protected Object doBlockingExecute() {
        return this.doBlockingExecute(this.buildCommand());
    }

    public void cleanUp() {
        this.m_Connection = null;
        super.cleanUp();
    }
}

