/*
 * Decompiled with CFR 0.152.
 */
package adams.docker.simpledocker;

import adams.core.QuickInfoHelper;
import adams.core.command.output.LineSplit;
import adams.core.command.output.OutputFormatter;
import adams.core.option.OptionHandler;
import adams.docker.simpledocker.AbstractDockerCommandWithOptions;
import java.util.List;

public class ListImages
extends AbstractDockerCommandWithOptions {
    private static final long serialVersionUID = 34785283711877518L;
    protected boolean m_All;
    protected String m_Filter;
    protected boolean m_ShowOnlyIDs;

    public String globalInfo() {
        return "For listing image IDs ('docker image ls').\nFor more information see:\nhttps://docs.docker.com/engine/reference/commandline/image_ls/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)"");
        this.m_OptionManager.add("all", "all", (Object)false);
        this.m_OptionManager.add("show-only-ids", "showOnlyIDs", (Object)true);
    }

    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)(this.m_Filter.isEmpty() ? "-none-" : this.m_Filter), (String)", filter: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"all", (boolean)this.m_All, (String)"all", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"showOnlyIDs", (boolean)this.m_ShowOnlyIDs, (String)"only IDs", (String)", ");
        return result;
    }

    protected OutputFormatter getDefaultOutputFormatter() {
        return new LineSplit();
    }

    public void setFilter(String value) {
        this.m_Filter = value;
        this.reset();
    }

    public String getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to apply, ignored if empty; variables get expanded automatically.";
    }

    public void setAll(boolean value) {
        this.m_All = value;
        this.reset();
    }

    public boolean getAll() {
        return this.m_All;
    }

    public String allTipText() {
        return "If enabled, lists all images including intermediate ones.";
    }

    public void setShowOnlyIDs(boolean value) {
        this.m_ShowOnlyIDs = value;
        this.reset();
    }

    public boolean getShowOnlyIDs() {
        return this.m_ShowOnlyIDs;
    }

    public String showOnlyIDsTipText() {
        return "If enabled, only the IDs are output, otherwise all the information.";
    }

    @Override
    protected List<String> buildCommand() {
        List<String> result = super.buildCommand();
        result.add("image");
        result.add("ls");
        if (this.m_ShowOnlyIDs) {
            result.add("--quiet");
        }
        if (this.m_All) {
            result.add("--all");
        }
        if (!this.m_Filter.isEmpty()) {
            result.add("--filter");
            result.add(this.getFlowContext().getVariables().expand(this.m_Filter));
        }
        return result;
    }
}

