/*
 * Decompiled with CFR 0.152.
 */
package adams.docker.simpledocker;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.docker.simpledocker.AbstractDockerCommand;
import java.util.List;

public class PruneContainers
extends AbstractDockerCommand {
    private static final long serialVersionUID = 34785283711877518L;
    protected String m_Filter;

    public String globalInfo() {
        return "For pruning stopped containers ('docker container prune').\nFor more information see:\nhttps://docs.docker.com/engine/reference/commandline/container_prune/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)"");
    }

    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)(this.m_Filter.isEmpty() ? "-none-" : this.m_Filter), (String)", filter: ");
        return result;
    }

    public void setFilter(String value) {
        this.m_Filter = value;
        this.reset();
    }

    public String getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to apply (e.g. 'until=<timestamp>'), ignored if empty; variables get expanded automatically.";
    }

    @Override
    protected List<String> buildCommand() {
        List<String> result = super.buildCommand();
        result.add("container");
        result.add("prune");
        result.add("--force");
        if (!this.m_Filter.isEmpty()) {
            result.add("--filter");
            result.add(this.getFlowContext().getVariables().expand(this.m_Filter));
        }
        return result;
    }
}

