/*
 * Decompiled with CFR 0.152.
 */
package adams.docker.simpledocker;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.docker.simpledocker.AbstractDockerCommand;
import java.util.List;

public class PruneImages
extends AbstractDockerCommand {
    private static final long serialVersionUID = 34785283711877518L;
    protected String m_Filter;
    protected boolean m_All;

    public String globalInfo() {
        return "For pruning images ('docker image prune').\nFor more information see:\nhttps://docs.docker.com/engine/reference/commandline/image_prune/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)"");
        this.m_OptionManager.add("all", "all", (Object)false);
    }

    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)(this.m_Filter.isEmpty() ? "-none-" : this.m_Filter), (String)", filter: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"all", (boolean)this.m_All, (String)"all", (String)", ");
        return result;
    }

    public void setFilter(String value) {
        this.m_Filter = value;
        this.reset();
    }

    public String getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to apply (e.g. 'until=<timestamp>'), ignored if empty; variables get expanded automatically.";
    }

    public void setAll(boolean value) {
        this.m_All = value;
        this.reset();
    }

    public boolean getAll() {
        return this.m_All;
    }

    public String allTipText() {
        return "If enabled, prunes all images not just dangling ones.";
    }

    @Override
    protected List<String> buildCommand() {
        List<String> result = super.buildCommand();
        result.add("image");
        result.add("prune");
        result.add("--force");
        if (this.m_All) {
            result.add("--all");
        }
        if (!this.m_Filter.isEmpty()) {
            result.add("--filter");
            result.add(this.getFlowContext().getVariables().expand(this.m_Filter));
        }
        return result;
    }
}

