/*
 * Decompiled with CFR 0.152.
 */
package adams.docker.simpledocker;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.docker.simpledocker.AbstractDockerCommand;
import java.util.List;

public class Push
extends AbstractDockerCommand {
    private static final long serialVersionUID = -3235247889827794116L;
    protected String m_Image;
    protected boolean m_AllTags;
    protected boolean m_DisableContentTrust;
    protected boolean m_Quiet;

    public String globalInfo() {
        return "Pushes the specified image.Use non-blocking mode for better progress updates.\nFor more information see:\nhttps://docs.docker.com/engine/reference/commandline/push/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image", "image", (Object)"");
        this.m_OptionManager.add("all-tags", "allTags", (Object)false);
        this.m_OptionManager.add("disable-content-trust", "disableConentTrust", (Object)false);
        this.m_OptionManager.add("quiet", "quiet", (Object)false);
    }

    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"image", (Object)this.m_Image, (String)", image: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"allTags", (boolean)this.m_AllTags, (String)"all tags", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"disableContentTrust", (boolean)this.m_DisableContentTrust, (String)"no content trust", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"quiet", (boolean)this.m_Quiet, (String)"quiet", (String)", ");
        return result;
    }

    public void setImage(String value) {
        this.m_Image = value;
        this.reset();
    }

    public String getImage() {
        return this.m_Image;
    }

    public String imageTipText() {
        return "The name of the image to push.";
    }

    public void setAllTags(boolean value) {
        this.m_AllTags = value;
        this.reset();
    }

    public boolean getAllTags() {
        return this.m_AllTags;
    }

    public String allTagsTipText() {
        return "Whether to push all tags of this image.";
    }

    public void setDisableContentTrust(boolean value) {
        this.m_DisableContentTrust = value;
        this.reset();
    }

    public boolean getDisableContentTrust() {
        return this.m_DisableContentTrust;
    }

    public String disableContentTrustTipText() {
        return "Whether to skip image signing.";
    }

    public void setQuiet(boolean value) {
        this.m_Quiet = value;
        this.reset();
    }

    public boolean getQuiet() {
        return this.m_Quiet;
    }

    public String quietTipText() {
        return "If enabled, the output is less verbose.";
    }

    @Override
    protected List<String> buildCommand() {
        List<String> result = super.buildCommand();
        result.add("push");
        if (this.m_AllTags) {
            result.add("--all-tags");
        }
        if (this.m_DisableContentTrust) {
            result.add("--disable-content-trust");
        }
        if (this.m_Quiet) {
            result.add("--quiet");
        }
        result.add(this.m_Image);
        return result;
    }
}

