/*
 * Decompiled with CFR 0.152.
 */
package adams.docker.simpledocker;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.docker.simpledocker.AbstractDockerCommandWithOptions;
import adams.docker.simpledocker.DockerCommandWithProgrammaticArguments;
import java.util.Arrays;
import java.util.List;

public class RemoveContainers
extends AbstractDockerCommandWithOptions
implements DockerCommandWithProgrammaticArguments {
    private static final long serialVersionUID = 34785283711877518L;
    protected boolean m_Force;
    protected String[] m_AdditionalArguments;

    public String globalInfo() {
        return "For removing containers ('docker container stop').\nFor more information see:\nhttps://docs.docker.com/engine/reference/commandline/container_rm/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.insert(this.m_OptionManager.size() - 2, "force", "force", (Object)false);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"force", (boolean)this.m_Force, (String)(this.m_Force ? "force" : "normal"));
        result = (String)result + ", " + super.getQuickInfo();
        return result;
    }

    public void setForce(boolean value) {
        this.m_Force = value;
        this.reset();
    }

    public boolean getForce() {
        return this.m_Force;
    }

    public String forceTipText() {
        return "If enabled, the removal is forced (uses SIGKILL).";
    }

    public void setAdditionalArguments(String[] value) {
        this.m_AdditionalArguments = value;
    }

    public String[] getAdditionalArguments() {
        return this.m_AdditionalArguments;
    }

    @Override
    protected List<String> buildCommand() {
        List<String> result = super.buildCommand();
        result.add("container");
        result.add("rm");
        if (this.m_Force) {
            result.add("--force");
        }
        result.addAll(Arrays.asList(this.getActualOptions()));
        if (this.m_AdditionalArguments != null) {
            result.addAll(Arrays.asList(this.m_AdditionalArguments));
        }
        return result;
    }
}

