/*
 * Decompiled with CFR 0.152.
 */
package adams.docker.simpledocker;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.DockerDirectoryMapping;
import adams.core.management.User;
import adams.core.option.OptionHandler;
import adams.docker.simpledocker.AbstractDockerCommandWithOptions;
import adams.docker.simpledocker.PullType;
import adams.flow.standalone.SimpleDockerConnection;
import java.util.Arrays;
import java.util.List;

public class Run
extends AbstractDockerCommandWithOptions {
    private static final long serialVersionUID = -681107300094757081L;
    protected boolean m_RemoveContainer;
    protected boolean m_RunAsUser;
    protected PullType m_PullType;

    public String globalInfo() {
        return "Performs the 'docker run' command in either blocking or async fashion.\nThe latter is useful for long-running commands as it supports incremental output.\nFor more information see:\nhttps://docs.docker.com/engine/reference/commandline/run/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.insert(this.m_OptionManager.size() - 2, "remove-container", "removeContainer", (Object)false);
        this.m_OptionManager.insert(this.m_OptionManager.size() - 2, "run-as-user", "runAsUser", (Object)false);
        this.m_OptionManager.insert(this.m_OptionManager.size() - 2, "pull-type", "pullType", (Object)PullType.DEFAULT);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"runAsUser", (Object)(this.m_RunAsUser ? "user" : "root"), (String)"run as: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"removeContainer", (boolean)this.m_RemoveContainer, (String)"remove container", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"pullType", (Object)((Object)this.m_PullType), (String)", pull: ");
        result = (String)result + ", " + super.getQuickInfo();
        return result;
    }

    public void setRemoveContainer(boolean value) {
        this.m_RemoveContainer = value;
        this.reset();
    }

    public boolean getRemoveContainer() {
        return this.m_RemoveContainer;
    }

    public String removeContainerTipText() {
        return "If enabled, the --rm flag for removing the container is added to the command.";
    }

    public void setRunAsUser(boolean value) {
        this.m_RunAsUser = value;
        this.reset();
    }

    public boolean getRunAsUser() {
        return this.m_RunAsUser;
    }

    public String runAsUserTipText() {
        return "If enabled, the container is run as the current user using the '-u' option.";
    }

    public void setPullType(PullType value) {
        this.m_PullType = value;
        this.reset();
    }

    public PullType getPullType() {
        return this.m_PullType;
    }

    public String pullTypeTipText() {
        return "Determines how to pull the image; used to override the setting defined in " + Utils.classToString(SimpleDockerConnection.class) + ".";
    }

    public PullType getActualPullType() {
        if (this.m_Connection == null) {
            return this.m_PullType;
        }
        return this.m_Connection.getActualPullType(this.m_PullType);
    }

    @Override
    protected String check() {
        String[] options;
        String result = super.check();
        if (result == null && (options = this.getActualOptions()).length == 0) {
            result = "No options provided! Minimum is the name of a docker image!";
        }
        return result;
    }

    @Override
    protected List<String> buildCommand() {
        List<String> result = super.buildCommand();
        result.add("run");
        if (this.getActualPullType() != PullType.DEFAULT) {
            result.add("--pull");
            result.add(this.getActualPullType().getType());
        }
        for (DockerDirectoryMapping mapping : this.m_Connection.getExpandedDirMappings()) {
            result.add("-v");
            result.add(mapping.getExpandedValue());
        }
        if (this.m_RemoveContainer) {
            result.add("--rm");
        }
        if (this.m_RunAsUser) {
            result.add("-u");
            result.add(User.getUserID() + ":" + User.getGroupID());
        }
        result.addAll(Arrays.asList(this.getActualOptions()));
        return result;
    }
}

