/*
 * Decompiled with CFR 0.152.
 */
package adams.docker.simpledocker;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.docker.simpledocker.AbstractDockerCommandWithOptions;
import adams.docker.simpledocker.DockerCommandWithProgrammaticArguments;
import java.util.Arrays;
import java.util.List;

public class StopContainers
extends AbstractDockerCommandWithOptions
implements DockerCommandWithProgrammaticArguments {
    private static final long serialVersionUID = 34785283711877518L;
    protected int m_Wait;
    protected String[] m_AdditionalArguments;

    public String globalInfo() {
        return "For stopping containers ('docker container stop').\nFor more information see:\nhttps://docs.docker.com/engine/reference/commandline/container_stop/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.insert(this.m_OptionManager.size() - 2, "wait", "wait", (Object)10, (Number)0, null);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"wait", (Object)this.m_Wait, (String)"wait: ");
        result = (String)result + ", " + super.getQuickInfo();
        return result;
    }

    public void setWait(int value) {
        if (this.getOptionManager().isValid("wait", (Number)value)) {
            this.m_Wait = value;
            this.reset();
        }
    }

    public int getWait() {
        return this.m_Wait;
    }

    public String waitTipText() {
        return "The number of seconds to wait before stopping the container(s).";
    }

    public void setAdditionalArguments(String[] value) {
        this.m_AdditionalArguments = value;
    }

    public String[] getAdditionalArguments() {
        return this.m_AdditionalArguments;
    }

    @Override
    protected List<String> buildCommand() {
        List<String> result = super.buildCommand();
        result.add("container");
        result.add("stop");
        result.add("--time");
        result.add("" + this.m_Wait);
        result.addAll(Arrays.asList(this.getActualOptions()));
        if (this.m_AdditionalArguments != null) {
            result.addAll(Arrays.asList(this.m_AdditionalArguments));
        }
        return result;
    }
}

