/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.docker.simpledocker.DockerCommand;
import adams.docker.simpledocker.Run;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.standalone.SimpleDockerConnection;

public class SimpleDockerCommand
extends AbstractSource {
    private static final long serialVersionUID = 7628077317238673283L;
    protected DockerCommand m_Command;
    protected transient SimpleDockerConnection m_Connection;

    public String globalInfo() {
        return "Executes the specified docker command and forwards the output it generates.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("command", "command", (Object)new Run());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"command", (Object)this.m_Command);
    }

    public void setCommand(DockerCommand value) {
        this.m_Command = value;
        this.reset();
    }

    public DockerCommand getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The docker command to run.";
    }

    public Class[] generates() {
        return new Class[]{this.m_Command.generates()};
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null) {
            this.m_Connection = (SimpleDockerConnection)ActorUtils.findClosestType((Actor)this, SimpleDockerConnection.class, (boolean)true);
            if (this.m_Connection == null) {
                result = "No " + Utils.classToString(SimpleDockerConnection.class) + " actor found!";
            } else if (this.m_Connection.getAcualBinary() == null) {
                result = "No docker binary available from: " + this.m_Connection.getFullName();
            }
        }
        return result;
    }

    protected String doExecute() {
        this.m_Command.setFlowContext((Actor)this);
        this.m_Command.setConnection(this.m_Connection);
        return this.m_Command.execute();
    }

    public Token output() {
        Token result = null;
        Object output = null;
        if (this.m_Command.hasOutput()) {
            output = this.m_Command.output();
        }
        if (output != null) {
            result = new Token(output);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.isExecuted() && (this.m_Command.isRunning() || this.m_Command.hasOutput());
    }

    public void stopExecution() {
        this.m_Command.stopExecution();
        super.stopExecution();
    }

    public void cleanUp() {
        this.m_Command.cleanUp();
        super.cleanUp();
    }
}

