/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.base.BasePassword;
import adams.core.base.DockerDirectoryMapping;
import adams.core.io.PlaceholderFile;
import adams.core.management.CommandResult;
import adams.core.management.OS;
import adams.core.option.OptionHandler;
import adams.docker.SimpleDockerHelper;
import adams.docker.simpledocker.PullType;
import adams.flow.standalone.AbstractStandalone;

public class SimpleDockerConnection
extends AbstractStandalone {
    private static final long serialVersionUID = -7794355274296751461L;
    protected String m_Registry;
    protected String m_User;
    protected BasePassword m_Password;
    protected PlaceholderFile m_Binary;
    protected DockerDirectoryMapping[] m_DirMappings;
    protected transient DockerDirectoryMapping[] m_ExpandedDirMappings;
    protected boolean m_Login;
    protected boolean m_Logout;
    protected PullType m_PullType;
    protected String m_ActualBinary;

    public String globalInfo() {
        return "Wraps around the local docker binary and can (optionally) log in to the registry (and log out once the flow finishes).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("registry", "registry", (Object)"");
        this.m_OptionManager.add("user", "user", (Object)"");
        this.m_OptionManager.add("password", "password", (Object)new BasePassword());
        this.m_OptionManager.add("binary", "binary", (Object)new PlaceholderFile());
        this.m_OptionManager.add("dir-mapping", "dirMappings", (Object)new DockerDirectoryMapping[0]);
        this.m_OptionManager.add("login", "login", (Object)false);
        this.m_OptionManager.add("logout", "logout", (Object)false);
        this.m_OptionManager.add("pull-type", "pullType", (Object)PullType.DEFAULT);
    }

    protected void reset() {
        super.reset();
        this.m_ExpandedDirMappings = null;
    }

    public void setRegistry(String value) {
        this.m_Registry = value;
        this.reset();
    }

    public String getRegistry() {
        return this.m_Registry;
    }

    public String registryTipText() {
        return "The custom registry to use, uses docker hub if left empty.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The registry user to use.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The registry password to use.";
    }

    public void setBinary(PlaceholderFile value) {
        this.m_Binary = value;
        this.reset();
    }

    public PlaceholderFile getBinary() {
        return this.m_Binary;
    }

    public String binaryTipText() {
        return "The docker binary to use, uses default if pointing to dir.";
    }

    public void setDirMappings(DockerDirectoryMapping[] value) {
        this.m_DirMappings = value;
        this.reset();
    }

    public DockerDirectoryMapping[] getDirMappings() {
        return this.m_DirMappings;
    }

    public String dirMappingsTipText() {
        return "The directory mappings to make available to the actual docker commands.";
    }

    public DockerDirectoryMapping[] getExpandedDirMappings() {
        if (this.m_ExpandedDirMappings == null) {
            DockerDirectoryMapping[] result = new DockerDirectoryMapping[this.m_DirMappings.length];
            if (this.m_DirMappings.length > 0) {
                Variables vars = this.getVariables();
                Placeholders phs = Placeholders.getSingleton();
                for (int i = 0; i < this.m_DirMappings.length; ++i) {
                    result[i] = new DockerDirectoryMapping(vars.expand(phs.expand(this.m_DirMappings[i].localDir())), vars.expand(this.m_DirMappings[i].containerDir()));
                }
            }
            this.m_ExpandedDirMappings = result;
        }
        return this.m_ExpandedDirMappings;
    }

    public void setLogin(boolean value) {
        this.m_Login = value;
        this.reset();
    }

    public boolean getLogin() {
        return this.m_Login;
    }

    public String loginTipText() {
        return "Whether to log in to the registry when the flow starts.";
    }

    public void setLogout(boolean value) {
        this.m_Logout = value;
        this.reset();
    }

    public boolean getLogout() {
        return this.m_Logout;
    }

    public String logoutTipText() {
        return "Whether to log out to the registry when the flow wraps up.";
    }

    public void setPullType(PullType value) {
        this.m_PullType = value;
        this.reset();
    }

    public PullType getPullType() {
        return this.m_PullType;
    }

    public String pullTypeTipText() {
        return "Determines how to pull images.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"registry", (Object)(this.m_Registry.isEmpty() ? "-default-" : this.m_Registry), (String)"registry: ");
        if (!this.m_User.isEmpty() || this.getOptionManager().hasVariableForProperty("user")) {
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"user", (Object)this.m_User, (String)", user: ");
        }
        if (!this.m_Password.isEmpty() || this.getOptionManager().hasVariableForProperty("password")) {
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"password", (Object)this.m_Password, (String)", pw: ");
        }
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"login", (boolean)this.m_Login, (String)"login", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"logout", (boolean)this.m_Logout, (String)"logout", (String)", ");
        if (this.getOptionManager().hasVariableForProperty("dirMappings") || this.m_DirMappings.length > 0) {
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"dirMappings", (Object)this.m_DirMappings, (String)", mappings: ");
        }
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"pullType", (Object)((Object)this.m_PullType), (String)", pull: ");
        return result;
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null) {
            this.m_ActualBinary = null;
            if (!this.m_Binary.isDirectory()) {
                if (!this.m_Binary.getAbsoluteFile().exists()) {
                    result = "Docker binary does not exist: " + this.m_Binary.getAbsolutePath();
                } else {
                    this.m_ActualBinary = this.m_Binary.getAbsolutePath();
                }
            } else {
                this.m_ActualBinary = OS.isWindows() ? "docker.exe" : "docker";
            }
        }
        return result;
    }

    public String getAcualBinary() {
        return this.m_ActualBinary;
    }

    public PullType getActualPullType(PullType override) {
        PullType result = this.m_PullType;
        if (override != PullType.DEFAULT) {
            result = override;
        }
        return result;
    }

    protected String doExecute() {
        Object result = null;
        if (this.m_ActualBinary == null) {
            result = "No docker binary available!";
        }
        if (result == null && this.m_Login) {
            CommandResult res = SimpleDockerHelper.login(this.getAcualBinary(), this.m_Registry, this.m_User, this.m_Password.getValue());
            if (res.exitCode != 0) {
                result = "Login failed!\nexit code: " + res.exitCode + (String)(res.stdout != null ? "\nstdout:\n" + res.stdout : "") + (String)(res.stderr != null ? "\nstderr:\n" + res.stderr : "");
            }
        }
        return result;
    }

    public void wrapUp() {
        if (this.m_ActualBinary != null && this.m_Logout) {
            CommandResult res = SimpleDockerHelper.logout(this.getAcualBinary(), this.m_Registry);
            if (res.exitCode != 0) {
                this.getLogger().warning("Logout failed!\nexit code: " + res.exitCode + (String)(res.stdout != null ? "\nstdout:\n" + res.stdout : "") + (String)(res.stderr != null ? "\nstderr:\n" + res.stderr : ""));
            }
        }
        super.wrapUp();
    }
}

