/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.docker.simpledocker.DockerCommandWithProgrammaticArguments;
import adams.docker.simpledocker.StopContainers;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.SimpleDockerConnection;
import adams.flow.transformer.AbstractTransformer;

public class SimpleDockerCommand
extends AbstractTransformer {
    private static final long serialVersionUID = 7628077317238673283L;
    protected DockerCommandWithProgrammaticArguments m_Command;
    protected transient SimpleDockerConnection m_Connection;

    public String globalInfo() {
        return "Supplies the specified docker command with the incoming additional arguments and forwards the output it generates on execution.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("command", "command", (Object)new StopContainers());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"command", (Object)this.m_Command);
    }

    public void setCommand(DockerCommandWithProgrammaticArguments value) {
        this.m_Command = value;
        this.reset();
    }

    public DockerCommandWithProgrammaticArguments getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The docker command to run.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, String[].class};
    }

    public Class[] generates() {
        return new Class[]{this.m_Command.generates()};
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null) {
            this.m_Connection = (SimpleDockerConnection)ActorUtils.findClosestType((Actor)this, SimpleDockerConnection.class, (boolean)true);
            if (this.m_Connection == null) {
                result = "No " + Utils.classToString(SimpleDockerConnection.class) + " actor found!";
            } else if (this.m_Connection.getAcualBinary() == null) {
                result = "No docker binary available from: " + this.m_Connection.getFullName();
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        String[] args = new String[]{};
        if (this.m_InputToken.hasPayload(String.class)) {
            args = new String[]{(String)this.m_InputToken.getPayload(String.class)};
        } else if (this.m_InputToken.hasPayload(String[].class)) {
            args = (String[])this.m_InputToken.getPayload(String[].class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            this.m_Command.setFlowContext((Actor)this);
            this.m_Command.setConnection(this.m_Connection);
            this.m_Command.setAdditionalArguments(args);
            result = this.m_Command.execute();
        }
        return result;
    }

    public Token output() {
        Token result = null;
        Object output = null;
        if (this.m_Command.hasOutput()) {
            output = this.m_Command.output();
        }
        if (output != null) {
            result = new Token(output);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.isExecuted() && (this.m_Command.isRunning() || this.m_Command.hasOutput());
    }

    public void stopExecution() {
        this.m_Command.stopExecution();
        super.stopExecution();
    }

    public void cleanUp() {
        this.m_Command.cleanUp();
        super.cleanUp();
    }
}

