/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.base.BaseObject;
import adams.core.base.DockerDirectoryMapping;
import adams.core.io.PlaceholderDirectory;
import adams.core.option.parsing.DockerDirectoryMappingParsing;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.BaseObjectEditor;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DockerDirectoryMappingEditor
extends BaseObjectEditor
implements MultiSelectionEditor {
    protected DirectoryChooserPanel m_TextLocal;

    protected void acceptInput() {
        String containerDir;
        String localDir = ((File)this.m_TextLocal.getCurrent()).getAbsolutePath();
        String pair = localDir + ":" + (containerDir = this.m_TextValue.getText());
        if (this.isValid(pair) && !this.isUnchanged(pair)) {
            this.setValue(this.parse(pair));
        }
        this.closeDialog(1);
    }

    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        ParameterPanel panelPair = new ParameterPanel();
        panelAll.add((Component)panelPair, "Center");
        this.m_TextLocal = new DirectoryChooserPanel();
        this.m_TextValue = new BaseTextField(30);
        panelPair.addParameter("_Local", (Component)this.m_TextLocal);
        panelPair.addParameter("_Container", (Component)this.m_TextValue);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        BaseButton buttonClear = new BaseButton("Clear");
        buttonClear.setMnemonic('l');
        buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerDirectoryMappingEditor.this.m_TextLocal.setCurrent((File)new PlaceholderDirectory());
                DockerDirectoryMappingEditor.this.m_TextValue.setText("");
            }
        });
        panelButtons.add((Component)buttonClear);
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerDirectoryMappingEditor.this.acceptInput();
            }
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonClose = new BaseButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerDirectoryMappingEditor.this.discardInput();
            }
        });
        panelButtons.add((Component)buttonClose);
        return panelAll;
    }

    protected void initForDisplay() {
        this.resetChosenOption();
        DockerDirectoryMapping value = (DockerDirectoryMapping)((Object)this.getValue());
        if (!((File)this.m_TextLocal.getCurrent()).getAbsolutePath().equals(value.localDir())) {
            this.m_TextLocal.setCurrent((File)new PlaceholderDirectory(value.localDir()));
        }
        if (!this.m_TextValue.getText().equals(value.containerDir())) {
            this.m_TextValue.setText(value.containerDir());
        }
        this.m_TextLocal.setToolTipText(((BaseObject)this.getValue()).getTipText());
        this.m_TextValue.setToolTipText(((BaseObject)this.getValue()).getTipText());
        this.m_TextLocal.grabFocus();
    }

    protected String getStringToPaint() {
        return ((DockerDirectoryMapping)((Object)this.getValue())).getValue();
    }

    public String toCustomStringRepresentation(Object obj) {
        return DockerDirectoryMappingParsing.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return DockerDirectoryMappingParsing.valueOf(null, str);
    }

    public Object[] getSelectedObjects(Container parent) {
        MultiLineValueDialog dialog = GUIHelper.getParentDialog((Container)parent) != null ? new MultiLineValueDialog(GUIHelper.getParentDialog((Container)parent)) : new MultiLineValueDialog(GUIHelper.getParentFrame((Container)parent));
        dialog.setInfoText("Enter the local/container dir pairs, one per line (separator ':'):");
        dialog.setLocationRelativeTo((Component)parent);
        dialog.setVisible(true);
        List lines = dialog.getValues();
        DockerDirectoryMapping[] result = new DockerDirectoryMapping[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            result[i] = (DockerDirectoryMapping)this.parse((String)lines.get(i));
        }
        return result;
    }
}

