/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Range;
import adams.data.conversion.Conversion;
import adams.data.conversion.StringToSpreadSheet;
import adams.data.io.input.AutoWidthTabularSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.docker.DockerContainer;
import adams.docker.simpledocker.ListContainers;
import adams.docker.simpledocker.RemoveContainers;
import adams.docker.simpledocker.StopContainers;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.source.StringConstants;
import adams.flow.standalone.SimpleDockerConnection;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SetStorageValue;
import adams.flow.transformer.SimpleDockerCommand;
import adams.flow.transformer.StringJoin;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanelWithButtons;
import adams.gui.core.SearchParameters;
import adams.gui.tools.AbstractManagementPanel;
import adams.gui.tools.AbstractManagementTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingWorker;

public class DockerContainersPanel
extends AbstractManagementPanel<DockerContainer> {
    protected BaseTextField m_TextContainerID;
    protected BaseTextField m_TextImage;
    protected BaseTextField m_TextCommand;
    protected BaseTextField m_TextCreated;
    protected BaseTextField m_TextStatus;
    protected BaseTextField m_TextPorts;
    protected BaseTextField m_TextNames;
    protected BaseButton m_ButtonStop;
    protected BaseButton m_ButtonDelete;

    protected void initGUI() {
        super.initGUI();
        this.m_ButtonStop = new BaseButton("Stop");
        this.m_ButtonStop.addActionListener(e -> this.stopContainers());
        this.m_TableValues.addToButtonsPanel((Component)this.m_ButtonStop);
        this.m_TableValues.addToButtonsPanel((Component)new JLabel());
        this.m_ButtonDelete = new BaseButton("Delete");
        this.m_ButtonDelete.addActionListener(e -> this.deleteContainers());
        this.m_TableValues.addToButtonsPanel((Component)this.m_ButtonDelete);
    }

    protected void addFields(ParameterPanelWithButtons panel) {
        this.m_TextContainerID = new BaseTextField();
        panel.addParameter("Container ID", (Component)this.m_TextContainerID);
        this.m_TextImage = new BaseTextField();
        panel.addParameter("Image", (Component)this.m_TextImage);
        this.m_TextCommand = new BaseTextField();
        panel.addParameter("Command", (Component)this.m_TextCommand);
        this.m_TextCreated = new BaseTextField();
        panel.addParameter("Created", (Component)this.m_TextCreated);
        this.m_TextStatus = new BaseTextField();
        panel.addParameter("Status", (Component)this.m_TextStatus);
        this.m_TextPorts = new BaseTextField();
        panel.addParameter("Ports", (Component)this.m_TextPorts);
        this.m_TextNames = new BaseTextField();
        panel.addParameter("Names", (Component)this.m_TextNames);
    }

    protected TableModel newTableModel() {
        return new TableModel();
    }

    protected Class getManagedClass() {
        return DockerContainer.class;
    }

    protected void clear() {
        this.m_TextContainerID.setText("");
        this.m_TextImage.setText("");
        this.m_TextCommand.setText("");
        this.m_TextCreated.setText("");
        this.m_TextStatus.setText("");
        this.m_TextPorts.setText("");
        this.m_TextNames.setText("");
    }

    protected DockerContainer fieldsToObject() {
        return new DockerContainer(this.m_TextContainerID.getText(), this.m_TextImage.getText(), this.m_TextCommand.getText(), this.m_TextCreated.getText(), this.m_TextStatus.getText(), this.m_TextPorts.getText(), this.m_TextNames.getText());
    }

    protected void objectToFields(DockerContainer value) {
        this.m_TextContainerID.setText(value.getContainerID());
        this.m_TextImage.setText(value.getImage());
        this.m_TextCommand.setText(value.getCommand());
        this.m_TextCreated.setText(value.getCreated());
        this.m_TextStatus.setText(value.getStatus());
        this.m_TextPorts.setText(value.getPorts());
        this.m_TextNames.setText(value.getNames());
    }

    protected void updateButtons() {
        super.updateButtons();
        this.m_ButtonDelete.setEnabled(this.m_TableValues.getSelectedRowCount() > 0);
    }

    protected Flow getListFlow() {
        Flow result = new Flow();
        result.add((Actor)new SimpleDockerConnection());
        ListContainers list = new ListContainers();
        list.setAll(true);
        list.setShowOnlyIDs(false);
        adams.flow.source.SimpleDockerCommand cmd = new adams.flow.source.SimpleDockerCommand();
        cmd.setCommand(list);
        result.add((Actor)cmd);
        StringJoin join = new StringJoin();
        join.setGlue("\\n");
        result.add((Actor)join);
        StringToSpreadSheet s2s = new StringToSpreadSheet();
        AutoWidthTabularSpreadSheetReader reader = new AutoWidthTabularSpreadSheetReader();
        reader.setTextColumns(new Range("first-last"));
        reader.setMinSpaces(2);
        s2s.setReader((SpreadSheetReader)reader);
        result.add((Actor)new Convert((Conversion)s2s));
        SetStorageValue ssv = new SetStorageValue("sheet");
        result.add((Actor)ssv);
        return result;
    }

    protected Flow getStopFlow(String[] ids) {
        Flow result = new Flow();
        result.add((Actor)new SimpleDockerConnection());
        result.add((Actor)new StringConstants(ids));
        SimpleDockerCommand cmd = new SimpleDockerCommand();
        StopContainers stop = new StopContainers();
        stop.setBlocking(true);
        cmd.setCommand(stop);
        result.add((Actor)cmd);
        result.add((Actor)new SetStorageValue("output"));
        return result;
    }

    protected Flow getDeleteFlow(String[] ids) {
        Flow result = new Flow();
        result.add((Actor)new SimpleDockerConnection());
        result.add((Actor)new StringConstants(ids));
        SimpleDockerCommand cmd = new SimpleDockerCommand();
        RemoveContainers remove = new RemoveContainers();
        remove.setForce(true);
        remove.setBlocking(true);
        cmd.setCommand(remove);
        result.add((Actor)cmd);
        result.add((Actor)new SetStorageValue("output"));
        return result;
    }

    protected void cleanUp(Flow flow) {
        flow.wrapUp();
        flow.cleanUp();
        flow.destroy();
    }

    protected List<DockerContainer> loadAll() {
        ArrayList<DockerContainer> result = new ArrayList<DockerContainer>();
        Flow flow = this.getListFlow();
        StorageName sname = new StorageName("sheet");
        String msg = flow.setUp();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to list docker containers (flow setup):\n" + msg));
            this.cleanUp(flow);
            return result;
        }
        msg = flow.execute();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to list docker containers (flow execution):\n" + msg));
            this.cleanUp(flow);
            return result;
        }
        if (!flow.getStorage().has(sname)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"No spreadsheet with docker containers generated - parsing of docker output failed?");
            this.cleanUp(flow);
            return result;
        }
        SpreadSheet sheet = (SpreadSheet)flow.getStorage().get(sname);
        for (Row row : sheet.rows()) {
            result.add(new DockerContainer(row.getCell(0).getContent(), row.getCell(1).getContent(), row.getCell(2).getContent(), row.getCell(3).getContent(), row.getCell(4).getContent(), row.getCell(5).getContent(), row.getCell(6).getContent()));
        }
        this.cleanUp(flow);
        return result;
    }

    protected void stopContainers() {
        List selected = this.getSelectedValues();
        int retVal = GUIHelper.showConfirmMessage((Component)((Object)this), (String)("Do you want to stop " + selected.size() + " docker container(s)?"));
        if (retVal != 0) {
            return;
        }
        String[] ids = new String[selected.size()];
        for (int i = 0; i < selected.size(); ++i) {
            ids[i] = ((DockerContainer)selected.get(i)).getContainerID();
        }
        Flow flow = this.getStopFlow(ids);
        StorageName sname = new StorageName("output");
        String msg = flow.setUp();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to stop docker containers (flow setup):\n" + msg));
            this.cleanUp(flow);
            return;
        }
        msg = flow.execute();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to stop docker containers (flow execution):\n" + msg));
            this.cleanUp(flow);
            return;
        }
        if (flow.getStorage().has(sname)) {
            Object output = "" + flow.getStorage().get(sname);
            if (((String)(output = ((String)output).trim())).length() > 0) {
                GUIHelper.showInformationMessage((Component)((Object)this), (String)("Output of stopping docker containers:\n" + (String)output));
            }
        }
        this.cleanUp(flow);
        this.refresh();
    }

    protected void deleteContainers(final String[] ids) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                Flow flow = DockerContainersPanel.this.getDeleteFlow(ids);
                StorageName sname = new StorageName("output");
                String msg = flow.setUp();
                if (msg != null) {
                    GUIHelper.showErrorMessage((Component)((Object)DockerContainersPanel.this), (String)("Failed to delete docker containers (flow setup):\n" + msg));
                    DockerContainersPanel.this.cleanUp(flow);
                    return null;
                }
                msg = flow.execute();
                if (msg != null) {
                    GUIHelper.showErrorMessage((Component)((Object)DockerContainersPanel.this), (String)("Failed to delete docker containers (flow execution):\n" + msg));
                    DockerContainersPanel.this.cleanUp(flow);
                    return null;
                }
                if (flow.getStorage().has(sname)) {
                    Object output = "" + flow.getStorage().get(sname);
                    if (((String)(output = ((String)output).trim())).length() > 0) {
                        GUIHelper.showInformationMessage((Component)((Object)DockerContainersPanel.this), (String)("Output of deleting docker containers:\n" + (String)output));
                    }
                }
                DockerContainersPanel.this.cleanUp(flow);
                return null;
            }

            @Override
            protected void done() {
                super.done();
                DockerContainersPanel.this.refresh();
            }
        };
        worker.execute();
    }

    protected void deleteContainers() {
        List selected = this.getSelectedValues();
        int retVal = GUIHelper.showConfirmMessage((Component)((Object)this), (String)("Do you want to delete " + selected.size() + " docker container(s)?"));
        if (retVal != 0) {
            return;
        }
        String[] ids = new String[selected.size()];
        for (int i = 0; i < selected.size(); ++i) {
            ids[i] = ((DockerContainer)selected.get(i)).getContainerID();
        }
        this.deleteContainers(ids);
    }

    protected boolean exists(DockerContainer value) {
        return false;
    }

    protected boolean store(DockerContainer value) {
        return false;
    }

    protected boolean remove(DockerContainer value) {
        return false;
    }

    protected boolean canClearFields() {
        return !this.m_TextContainerID.getText().isEmpty() || !this.m_TextImage.getText().isEmpty() || !this.m_TextCommand.getText().isEmpty() || !this.m_TextCreated.getText().isEmpty() || !this.m_TextStatus.getText().isEmpty() || !this.m_TextPorts.getText().isEmpty() || !this.m_TextNames.getText().isEmpty();
    }

    protected boolean isReadOnly() {
        return true;
    }

    protected boolean canAddObject() {
        return false;
    }

    public static class TableModel
    extends AbstractManagementTableModel<DockerContainer> {
        private static final long serialVersionUID = 5144740737933551956L;

        public TableModel() {
        }

        public TableModel(DockerContainer[] values) {
            super((Comparable[])values);
        }

        public int getColumnCount() {
            return 8;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Index";
                }
                case 1: {
                    return "Container ID";
                }
                case 2: {
                    return "Image";
                }
                case 3: {
                    return "Command";
                }
                case 4: {
                    return "Created";
                }
                case 5: {
                    return "Status";
                }
                case 6: {
                    return "Ports";
                }
                case 7: {
                    return "Names";
                }
            }
            throw new IllegalStateException("Unsupported column index: " + column);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Integer.class;
            }
            return String.class;
        }

        public Object getValueAt(int row, int column) {
            DockerContainer container = (DockerContainer)this.m_Values.get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return container.getContainerID();
                }
                case 2: {
                    return container.getImage();
                }
                case 3: {
                    return container.getCommand();
                }
                case 4: {
                    return container.getCreated();
                }
                case 5: {
                    return container.getStatus();
                }
                case 6: {
                    return container.getPorts();
                }
                case 7: {
                    return container.getNames();
                }
            }
            throw new IllegalStateException("Unsupported column index: " + column);
        }

        public boolean isSearchMatch(SearchParameters params, int row) {
            if (params.matches(((DockerContainer)this.m_Values.get(row)).getContainerID())) {
                return true;
            }
            if (params.matches(((DockerContainer)this.m_Values.get(row)).getImage())) {
                return true;
            }
            if (params.matches(((DockerContainer)this.m_Values.get(row)).getCommand())) {
                return true;
            }
            if (params.matches(((DockerContainer)this.m_Values.get(row)).getCreated())) {
                return true;
            }
            if (params.matches(((DockerContainer)this.m_Values.get(row)).getStatus())) {
                return true;
            }
            if (params.matches(((DockerContainer)this.m_Values.get(row)).getPorts())) {
                return true;
            }
            return params.matches(((DockerContainer)this.m_Values.get(row)).getNames());
        }
    }
}

