/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Range;
import adams.data.conversion.Conversion;
import adams.data.conversion.StringToSpreadSheet;
import adams.data.io.input.AutoWidthTabularSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.docker.DockerImage;
import adams.docker.simpledocker.ListImages;
import adams.docker.simpledocker.RemoveImages;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.source.StringConstants;
import adams.flow.standalone.SimpleDockerConnection;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SetStorageValue;
import adams.flow.transformer.SimpleDockerCommand;
import adams.flow.transformer.StringJoin;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanelWithButtons;
import adams.gui.core.SearchParameters;
import adams.gui.tools.AbstractManagementPanel;
import adams.gui.tools.AbstractManagementTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingWorker;

public class DockerImagesPanel
extends AbstractManagementPanel<DockerImage> {
    protected BaseTextField m_TextRepository;
    protected BaseTextField m_TextTag;
    protected BaseTextField m_TextImageID;
    protected BaseTextField m_TextCreated;
    protected BaseTextField m_TextSize;
    protected BaseButton m_ButtonDelete;

    protected void initGUI() {
        super.initGUI();
        this.m_TableValues.addToButtonsPanel((Component)new JLabel());
        this.m_ButtonDelete = new BaseButton("Delete");
        this.m_ButtonDelete.addActionListener(e -> this.deleteImages());
        this.m_TableValues.addToButtonsPanel((Component)this.m_ButtonDelete);
    }

    protected void addFields(ParameterPanelWithButtons panel) {
        this.m_TextRepository = new BaseTextField();
        panel.addParameter("Repository", (Component)this.m_TextRepository);
        this.m_TextTag = new BaseTextField();
        panel.addParameter("Tag", (Component)this.m_TextTag);
        this.m_TextImageID = new BaseTextField();
        panel.addParameter("Image ID", (Component)this.m_TextImageID);
        this.m_TextCreated = new BaseTextField();
        panel.addParameter("Created", (Component)this.m_TextCreated);
        this.m_TextSize = new BaseTextField();
        panel.addParameter("Size", (Component)this.m_TextSize);
    }

    protected TableModel newTableModel() {
        return new TableModel();
    }

    protected Class getManagedClass() {
        return DockerImage.class;
    }

    protected void clear() {
        this.m_TextRepository.setText("");
        this.m_TextTag.setText("");
        this.m_TextImageID.setText("");
        this.m_TextCreated.setText("");
        this.m_TextSize.setText("");
    }

    protected DockerImage fieldsToObject() {
        return new DockerImage(this.m_TextRepository.getText(), this.m_TextTag.getText(), this.m_TextImageID.getText(), this.m_TextCreated.getText(), this.m_TextSize.getText());
    }

    protected void objectToFields(DockerImage value) {
        this.m_TextRepository.setText(value.getRepository());
        this.m_TextTag.setText(value.getTag());
        this.m_TextImageID.setText(value.getImageID());
        this.m_TextCreated.setText(value.getCreated());
        this.m_TextSize.setText(value.getSize());
    }

    protected void updateButtons() {
        super.updateButtons();
        this.m_ButtonDelete.setEnabled(this.m_TableValues.getSelectedRowCount() > 0);
    }

    protected Flow getListFlow() {
        Flow result = new Flow();
        result.add((Actor)new SimpleDockerConnection());
        ListImages list = new ListImages();
        list.setAll(true);
        list.setShowOnlyIDs(false);
        adams.flow.source.SimpleDockerCommand cmd = new adams.flow.source.SimpleDockerCommand();
        cmd.setCommand(list);
        result.add((Actor)cmd);
        StringJoin join = new StringJoin();
        join.setGlue("\\n");
        result.add((Actor)join);
        StringToSpreadSheet s2s = new StringToSpreadSheet();
        AutoWidthTabularSpreadSheetReader reader = new AutoWidthTabularSpreadSheetReader();
        reader.setTextColumns(new Range("first-last"));
        reader.setMinSpaces(2);
        s2s.setReader((SpreadSheetReader)reader);
        result.add((Actor)new Convert((Conversion)s2s));
        SetStorageValue ssv = new SetStorageValue("sheet");
        result.add((Actor)ssv);
        return result;
    }

    protected Flow getDeleteFlow(String[] ids) {
        Flow result = new Flow();
        result.add((Actor)new SimpleDockerConnection());
        result.add((Actor)new StringConstants(ids));
        SimpleDockerCommand cmd = new SimpleDockerCommand();
        RemoveImages remove = new RemoveImages();
        remove.setBlocking(true);
        cmd.setCommand(remove);
        result.add((Actor)cmd);
        result.add((Actor)new SetStorageValue("output"));
        return result;
    }

    protected void cleanUp(Flow flow) {
        flow.wrapUp();
        flow.cleanUp();
        flow.destroy();
    }

    protected List<DockerImage> loadAll() {
        ArrayList<DockerImage> result = new ArrayList<DockerImage>();
        Flow flow = this.getListFlow();
        StorageName sname = new StorageName("sheet");
        String msg = flow.setUp();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to list docker images (flow setup):\n" + msg));
            this.cleanUp(flow);
            return result;
        }
        msg = flow.execute();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to list docker images (flow execution):\n" + msg));
            this.cleanUp(flow);
            return result;
        }
        if (!flow.getStorage().has(sname)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"No spreadsheet with docker images generated - parsing of docker output failed?");
            this.cleanUp(flow);
            return result;
        }
        SpreadSheet sheet = (SpreadSheet)flow.getStorage().get(sname);
        for (Row row : sheet.rows()) {
            result.add(new DockerImage(row.getCell(0).getContent(), row.getCell(1).getContent(), row.getCell(2).getContent(), row.getCell(3).getContent(), row.getCell(4).getContent()));
        }
        this.cleanUp(flow);
        return result;
    }

    protected void deleteImages(final String[] ids) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                Flow flow = DockerImagesPanel.this.getDeleteFlow(ids);
                StorageName sname = new StorageName("output");
                String msg = flow.setUp();
                if (msg != null) {
                    GUIHelper.showErrorMessage((Component)((Object)DockerImagesPanel.this), (String)("Failed to delete docker images (flow setup):\n" + msg));
                    DockerImagesPanel.this.cleanUp(flow);
                    return null;
                }
                msg = flow.execute();
                if (msg != null) {
                    GUIHelper.showErrorMessage((Component)((Object)DockerImagesPanel.this), (String)("Failed to delete docker images (flow execution):\n" + msg));
                    DockerImagesPanel.this.cleanUp(flow);
                    return null;
                }
                if (flow.getStorage().has(sname)) {
                    Object output = "" + flow.getStorage().get(sname);
                    if (((String)(output = ((String)output).trim())).length() > 0) {
                        GUIHelper.showInformationMessage((Component)((Object)DockerImagesPanel.this), (String)("Output of deleting docker images:\n" + (String)output));
                    }
                }
                DockerImagesPanel.this.cleanUp(flow);
                return null;
            }

            @Override
            protected void done() {
                super.done();
                DockerImagesPanel.this.refresh();
            }
        };
        worker.execute();
    }

    protected void deleteImages() {
        List selected = this.getSelectedValues();
        int retVal = GUIHelper.showConfirmMessage((Component)((Object)this), (String)("Do you want to delete " + selected.size() + " docker image(s)?"));
        if (retVal != 0) {
            return;
        }
        String[] ids = new String[selected.size()];
        for (int i = 0; i < selected.size(); ++i) {
            ids[i] = ((DockerImage)selected.get(i)).getImageID();
        }
        this.deleteImages(ids);
    }

    protected boolean exists(DockerImage value) {
        return false;
    }

    protected boolean store(DockerImage value) {
        return false;
    }

    protected boolean remove(DockerImage value) {
        return false;
    }

    protected boolean canClearFields() {
        return !this.m_TextRepository.getText().isEmpty() || !this.m_TextTag.getText().isEmpty() || !this.m_TextImageID.getText().isEmpty() || !this.m_TextCreated.getText().isEmpty() || !this.m_TextSize.getText().isEmpty();
    }

    protected boolean isReadOnly() {
        return true;
    }

    protected boolean canAddObject() {
        return false;
    }

    public static class TableModel
    extends AbstractManagementTableModel<DockerImage> {
        private static final long serialVersionUID = 5144740737933551956L;

        public TableModel() {
        }

        public TableModel(DockerImage[] values) {
            super((Comparable[])values);
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Index";
                }
                case 1: {
                    return "Repository";
                }
                case 2: {
                    return "Tag";
                }
                case 3: {
                    return "Image ID";
                }
                case 4: {
                    return "Created";
                }
                case 5: {
                    return "Size";
                }
            }
            throw new IllegalStateException("Unsupported column index: " + column);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Integer.class;
            }
            return String.class;
        }

        public Object getValueAt(int row, int column) {
            DockerImage image = (DockerImage)this.m_Values.get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return image.getRepository();
                }
                case 2: {
                    return image.getTag();
                }
                case 3: {
                    return image.getImageID();
                }
                case 4: {
                    return image.getCreated();
                }
                case 5: {
                    return image.getSize();
                }
            }
            throw new IllegalStateException("Unsupported column index: " + column);
        }

        public boolean isSearchMatch(SearchParameters params, int row) {
            if (params.matches(((DockerImage)this.m_Values.get(row)).getRepository())) {
                return true;
            }
            if (params.matches(((DockerImage)this.m_Values.get(row)).getTag())) {
                return true;
            }
            if (params.matches(((DockerImage)this.m_Values.get(row)).getImageID())) {
                return true;
            }
            if (params.matches(((DockerImage)this.m_Values.get(row)).getCreated())) {
                return true;
            }
            return params.matches(((DockerImage)this.m_Values.get(row)).getSize());
        }
    }
}

