/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.logevent;

import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.flow.standalone.logevent.AbstractLogRecordFilter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LevelFilter
extends AbstractLogRecordFilter {
    private static final long serialVersionUID = 7462983936603453991L;
    protected LoggingLevel m_Minimum;
    protected LoggingLevel m_Maximum;

    public String globalInfo() {
        return "Filters records based on their logging level, i.e., if the fall in the specified min/max (inclusive).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("minimum", "minimum", (Object)LoggingLevel.SEVERE);
        this.m_OptionManager.add("maximum", "maximum", (Object)LoggingLevel.FINEST);
    }

    public void setMinimum(LoggingLevel value) {
        this.m_Minimum = value;
        this.reset();
    }

    public LoggingLevel getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum level to accept.";
    }

    public void setMaximum(LoggingLevel value) {
        this.m_Maximum = value;
        this.reset();
    }

    public LoggingLevel getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum level to accept.";
    }

    @Override
    public boolean acceptRecord(LogRecord record) {
        return LoggingHelper.isAtLeast((Level)record.getLevel(), (Level)this.m_Minimum.getLevel()) && LoggingHelper.isAtMost((Level)record.getLevel(), (Level)this.m_Maximum.getLevel());
    }
}

