/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.VariableNameNoUpdate;
import adams.core.option.OptionHandler;
import adams.event.VariableChangeEvent;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.AbstractMutableActorDaemonEvent;

public class VariableChangedEvent
extends AbstractMutableActorDaemonEvent<VariableChangeEvent, Object> {
    private static final long serialVersionUID = 4670761846363281951L;
    protected VariableNameNoUpdate m_Variable;

    public String globalInfo() {
        return "Listens to a any changes to the specified variable.\nThis allows, for instance, the monitoring of a variable.\nEnable the 'noDiscard' property to process all change events - NB: this can slow down the system significantly.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variable", "variable", (Object)new VariableNameNoUpdate());
    }

    public void setVariable(VariableNameNoUpdate value) {
        this.m_Variable = value;
        this.reset();
    }

    public VariableNameNoUpdate getVariable() {
        return this.m_Variable;
    }

    public String variableTipText() {
        return "The variable to monitor for changes.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"variable", (Object)this.m_Variable, (String)"var: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"noDiscard", (boolean)this.m_NoDiscard, (String)"no discard", (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    @Override
    protected String checkActors(AbstractActor[] actors) {
        for (int i = 0; i < actors.length; ++i) {
            if (actors[i].getSkip() || ActorUtils.isStandalone((Actor)actors[i])) continue;
            if (ActorUtils.isSource((Actor)actors[i])) break;
            return "Actor #" + (i + 1) + " does not produce any output!";
        }
        return null;
    }

    @Override
    protected boolean handlesEvent(VariableChangeEvent e) {
        return true;
    }

    @Override
    protected Object preProcessEvent(VariableChangeEvent e) {
        return e;
    }

    @Override
    protected boolean usePreProcessedAsInput() {
        return false;
    }

    public void variableChanged(VariableChangeEvent e) {
        if (e.getName().equals(this.m_Variable.getValue())) {
            this.processEvent(e);
        }
    }
}

