/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.flow.control.AbstractControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.DaemonEvent;
import adams.flow.core.Event;
import adams.flow.core.MutableActorHandler;
import java.util.ArrayList;
import java.util.List;

public class Events
extends AbstractControlActor
implements MutableActorHandler {
    private static final long serialVersionUID = -8393224234458401716L;
    protected List<AbstractActor> m_Actors;

    public String globalInfo() {
        return "Container for event actors.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new ArrayList<AbstractActor>();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actors", (Object)new AbstractActor[0]);
    }

    public String check() {
        String result = super.check();
        if (result == null) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.getScopeHandler() == null) continue;
                result = this.getScopeHandler().addGlobalName(this.get(i).getName());
            }
        }
        return result;
    }

    protected AbstractActor checkActor(AbstractActor actor) {
        if (!(actor instanceof Event)) {
            throw new IllegalArgumentException("Only " + Event.class.getName() + " actors are accepted, " + "provided: " + actor.getClass().getName());
        }
        if (this.getScopeHandler() != null && this.getScopeHandler().isGlobalNameUsed(actor.getName())) {
            throw new IllegalArgumentException(this.getScopeHandler().addGlobalName(actor.getName()));
        }
        return actor;
    }

    public void setActors(AbstractActor[] value) {
        ActorUtils.uniqueNames((AbstractActor[])value);
        this.m_Actors.clear();
        for (int i = 0; i < value.length; ++i) {
            this.m_Actors.add(this.checkActor(value[i]));
        }
        this.updateParent();
        this.reset();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.toArray(new AbstractActor[this.m_Actors.size()]);
    }

    public String actorsTipText() {
        return "The managed events.";
    }

    public int size() {
        return this.m_Actors.size();
    }

    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    public void set(int index, AbstractActor actor) {
        if (index > -1 && index < this.m_Actors.size()) {
            ActorUtils.uniqueName((AbstractActor)actor, (ActorHandler)this, (int)index);
            this.m_Actors.set(index, this.checkActor(actor));
            this.reset();
            this.updateParent();
        } else {
            this.getLogger().severe("Index out of range (0-" + (this.m_Actors.size() - 1) + "): " + index);
        }
    }

    public void add(AbstractActor actor) {
        this.add(this.size(), actor);
    }

    public void add(int index, AbstractActor actor) {
        this.m_Actors.add(index, this.checkActor(actor));
        this.reset();
        this.updateParent();
    }

    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.clear();
        this.reset();
    }

    public int indexOf(String actor) {
        int result = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getName().equals(actor)) continue;
            result = i;
            break;
        }
        return result;
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, true, ActorExecution.UNDEFINED, false, new Class[]{Event.class});
    }

    protected String doExecute() {
        String result = null;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (this.m_Actors.get(i) instanceof DaemonEvent) {
                result = this.m_Actors.get(i).execute();
            }
            if (result != null) break;
        }
        return result;
    }
}

