/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.base.CronSchedule;
import adams.core.option.AbstractOption;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseButtonWithDropDownMenu;
import adams.gui.core.BaseTextField;
import adams.gui.core.BrowserHelper;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.quartz.CronExpression;

public class CronScheduleEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
InlineEditorSupport {
    protected ParameterPanel m_PanelParts;
    protected BaseTextField m_TextSeconds;
    protected BaseTextField m_TextMinutes;
    protected BaseTextField m_TextHours;
    protected BaseTextField m_TextDayOfMonth;
    protected BaseTextField m_TextMonth;
    protected BaseTextField m_TextDayOfWeek;
    protected BaseTextField m_TextYear;

    public static String toString(AbstractOption option, Object object) {
        return ((CronSchedule)((Object)object)).stringValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new CronSchedule(Utils.unbackQuoteChars((String)str));
    }

    public String toCustomStringRepresentation(Object obj) {
        return CronScheduleEditor.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return CronScheduleEditor.valueOf(null, str);
    }

    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + CronScheduleEditor.toString(null, this.getValue()) + "\")";
        return result;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "null" : CronScheduleEditor.toString(null, this.getValue());
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected String getCurrentExpression() {
        String result = this.m_TextSeconds.getText() + " " + this.m_TextMinutes.getText() + " " + this.m_TextHours.getText() + " " + this.m_TextDayOfMonth.getText() + " " + this.m_TextMonth.getText() + " " + this.m_TextDayOfWeek.getText() + " " + this.m_TextYear.getText();
        result = result.trim();
        return result;
    }

    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        this.m_TextSeconds = new BaseTextField(5);
        this.m_TextSeconds.setToolTipText("0-59 and , - * /");
        this.m_TextMinutes = new BaseTextField(5);
        this.m_TextMinutes.setToolTipText("0-59 and , - * /");
        this.m_TextHours = new BaseTextField(5);
        this.m_TextHours.setToolTipText("0-23 and , - * /");
        this.m_TextDayOfMonth = new BaseTextField(5);
        this.m_TextDayOfMonth.setToolTipText("1-31 and , - * ? / L W");
        this.m_TextMonth = new BaseTextField(5);
        this.m_TextMonth.setToolTipText("1-12 or JAN-DEC and , - * /");
        this.m_TextDayOfWeek = new BaseTextField(5);
        this.m_TextDayOfWeek.setToolTipText("1-7 and , - * ? / L #");
        this.m_TextYear = new BaseTextField(5);
        this.m_TextYear.setToolTipText("empty, 1970-2099 and , - * /");
        this.m_PanelParts = new ParameterPanel();
        this.m_PanelParts.addParameter("_Seconds", (Component)this.m_TextSeconds);
        this.m_PanelParts.addParameter("_Minutes", (Component)this.m_TextMinutes);
        this.m_PanelParts.addParameter("_Hours", (Component)this.m_TextHours);
        this.m_PanelParts.addParameter("_Day of month", (Component)this.m_TextDayOfMonth);
        this.m_PanelParts.addParameter("M_onth", (Component)this.m_TextMonth);
        this.m_PanelParts.addParameter("Day of _week", (Component)this.m_TextDayOfWeek);
        this.m_PanelParts.addParameter("_Year (optional)", (Component)this.m_TextYear);
        panelAll.add((Component)this.m_PanelParts, "Center");
        JPanel panelBottom = new JPanel(new BorderLayout());
        panelAll.add((Component)panelBottom, "South");
        JPanel panelButtons = new JPanel(new FlowLayout(0));
        panelBottom.add((Component)panelButtons, "West");
        BaseButton buttonHelp = new BaseButton((Icon)GUIHelper.getIcon((String)this.getHelpIcon()));
        buttonHelp.setToolTipText(this.getHelpDescription());
        buttonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserHelper.openURL((String)CronScheduleEditor.this.getHelpURL());
            }
        });
        panelButtons.add((Component)buttonHelp);
        BaseButtonWithDropDownMenu buttonTemplates = new BaseButtonWithDropDownMenu((Icon)GUIHelper.getIcon((String)"template.gif"));
        buttonTemplates.setToolTipText(this.getHelpDescription());
        Map templates = BaseObject.getTemplates(CronSchedule.class);
        ArrayList items = new ArrayList(templates.keySet());
        Collections.sort(items);
        for (String item : items) {
            JMenuItem menuitem = new JMenuItem(item);
            menuitem.addActionListener(ae -> this.setValue(templates.get(item)));
            buttonTemplates.addToMenu(menuitem);
        }
        panelButtons.add((Component)buttonTemplates);
        BaseButton buttonValidate = new BaseButton((Icon)GUIHelper.getIcon((String)"validate.png"));
        buttonValidate.setToolTipText("Checks the validity of the expressions");
        buttonValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CronSchedule cs = new CronSchedule();
                String s = CronScheduleEditor.this.getCurrentExpression();
                if (cs.isValid(s)) {
                    GUIHelper.showInformationMessage((Component)GUIHelper.getParentComponent((Component)CronScheduleEditor.this.m_CustomEditor), (String)("Expression '" + s + "' is valid!"));
                } else {
                    GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)CronScheduleEditor.this.m_CustomEditor), (String)("Expression '" + s + "' is not valid!"));
                }
            }
        });
        panelButtons.add((Component)buttonValidate);
        panelButtons = new JPanel(new FlowLayout(2));
        panelBottom.add((Component)panelButtons, "East");
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = CronScheduleEditor.this.getCurrentExpression();
                if (((CronSchedule)((Object)CronScheduleEditor.this.getValue())).isValid(s) && !s.equals(((BaseObject)CronScheduleEditor.this.getValue()).getValue())) {
                    CronScheduleEditor.this.setValue((Object)new CronSchedule(s));
                }
                CronScheduleEditor.this.closeDialog(1);
            }
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonClose = new BaseButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CronScheduleEditor.this.closeDialog(0);
            }
        });
        panelButtons.add((Component)buttonClose);
        return panelAll;
    }

    public boolean isInlineEditingAvailable() {
        return true;
    }

    public void setInlineValue(String value) {
        if (this.isInlineValueValid(value)) {
            this.setValue((Object)new CronSchedule(value));
        }
    }

    public String getInlineValue() {
        return ((BaseObject)this.getValue()).getValue();
    }

    public boolean isInlineValueValid(String value) {
        return ((CronSchedule)((Object)this.getValue())).isValid(value);
    }

    protected void initForDisplay() {
        super.initForDisplay();
        String value = "" + this.getValue();
        if (!this.getCurrentExpression().equals(value)) {
            String expr;
            try {
                expr = new CronExpression(value).toString();
            }
            catch (Exception e) {
                expr = "0 0 1 * * ?";
            }
            String[] parts = expr.toString().split(" ");
            if (parts.length > 0) {
                this.m_TextSeconds.setText(parts[0]);
            }
            if (parts.length > 1) {
                this.m_TextMinutes.setText(parts[1]);
            }
            if (parts.length > 2) {
                this.m_TextHours.setText(parts[2]);
            }
            if (parts.length > 3) {
                this.m_TextDayOfMonth.setText(parts[3]);
            }
            if (parts.length > 4) {
                this.m_TextMonth.setText(parts[4]);
            }
            if (parts.length > 5) {
                this.m_TextDayOfWeek.setText(parts[5]);
            }
            if (parts.length > 6) {
                this.m_TextYear.setText(parts[6]);
            }
        }
    }
}

