/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.option.AbstractOption;
import adams.flow.core.EventReference;
import adams.flow.standalone.Events;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextField;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.MouseUtils;
import adams.gui.flow.tree.Node;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.FlowHelper;
import adams.gui.goe.actorpathtree.ActorPathNode;
import adams.gui.goe.eventstree.EventsTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class EventReferenceEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected BaseTextField m_TextValue;
    protected EventsTree m_Tree;

    public static String toString(AbstractOption option, Object object) {
        return ((EventReference)((Object)object)).getValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new EventReference(str);
    }

    public String toCustomStringRepresentation(Object obj) {
        return EventReferenceEditor.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return new EventReference(str);
    }

    public String getJavaInitializationString() {
        String result = "new " + EventReference.class.getName() + "(\"" + Utils.backQuoteChars((String)this.getValue().toString()) + "\")";
        return result;
    }

    protected String getStringToPaint() {
        return "" + this.getValue();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getStringToPaint();
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected EventReference parse(String s) {
        EventReference result;
        try {
            result = new EventReference();
            result.setValue(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    protected boolean updateValue(TreePath path) {
        ActorPathNode event;
        BaseTreeNode node;
        boolean result = false;
        if (path != null && (node = (BaseTreeNode)path.getLastPathComponent()) instanceof ActorPathNode && (event = (ActorPathNode)node).hasClassname()) {
            this.m_TextValue.setText(event.getLabel());
            result = true;
        }
        return result;
    }

    protected JComponent createCustomEditor() {
        JPanel panelTree = new JPanel(new BorderLayout(0, 5));
        panelTree.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.m_Tree = new EventsTree();
        this.m_Tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                EventReferenceEditor.this.updateValue(e.getPath());
            }
        });
        this.m_Tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selPath = EventReferenceEditor.this.m_Tree.getPathForLocation(e.getX(), e.getY());
                if (MouseUtils.isDoubleClick((MouseEvent)e) && EventReferenceEditor.this.updateValue(selPath)) {
                    e.consume();
                    EventReferenceEditor.this.acceptInput();
                }
                if (!e.isConsumed()) {
                    super.mousePressed(e);
                }
            }
        });
        panelTree.add((Component)new BaseScrollPane((Component)((Object)this.m_Tree)), "Center");
        panelTree.add((Component)new JLabel("Select event:"), "North");
        JPanel panelAll = new JPanel(new BorderLayout());
        panelTree.add((Component)panelAll, "South");
        JPanel panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "Center");
        this.m_TextValue = new BaseTextField(20);
        this.m_TextValue.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    EventReferenceEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    EventReferenceEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JLabel label = new JLabel("Manual reference");
        label.setDisplayedMnemonic('M');
        label.setLabelFor((Component)this.m_TextValue);
        panel.add(label);
        panel.add((Component)this.m_TextValue);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventReferenceEditor.this.acceptInput();
            }
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonClose = new BaseButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventReferenceEditor.this.discardInput();
            }
        });
        panelButtons.add((Component)buttonClose);
        return panelTree;
    }

    protected boolean isValid(String s) {
        return ((EventReference)((Object)this.getValue())).isValid(s);
    }

    protected boolean isUnchanged(String s) {
        return s.equals(((EventReference)((Object)this.getValue())).getValue());
    }

    protected void acceptInput() {
        String s = this.m_TextValue.getText();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue((Object)this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    protected boolean isValidNode(Node node) {
        return true;
    }

    protected List<String> findEvents() {
        ArrayList<String> result = new ArrayList<String>();
        List events = FlowHelper.findNodes((Container)this.m_CustomEditor, Events.class);
        for (Node event : events) {
            result.add(event.getFullName());
            for (int i = 0; i < event.getChildCount(); ++i) {
                Node child = (Node)event.getChildAt(i);
                if (child.getActor().getSkip() || !this.isValidNode(child)) continue;
                result.add(child.getFullName());
            }
        }
        return result;
    }

    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextValue.getText().equals("" + this.getValue())) {
            this.m_TextValue.setText("" + this.getValue());
        }
        this.m_TextValue.setToolTipText(((EventReference)((Object)this.getValue())).getTipText());
        this.m_Tree.setFlowTree(FlowHelper.getTree((Container)this.m_CustomEditor));
        this.m_Tree.setItems(this.findEvents());
        this.m_Tree.expandAll();
        this.m_Tree.selectNodeByName(this.m_TextValue.getText());
        this.m_TextValue.grabFocus();
    }
}

