/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.flowrestart.trigger;

import adams.core.QuickInfoHelper;
import adams.core.base.CronSchedule;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.control.flowrestart.trigger.AbstractTrigger;
import adams.flow.control.flowrestart.trigger.Null;
import adams.flow.core.EventHelper;
import java.util.Date;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.Trigger;

public class MetaCron
extends AbstractTrigger {
    private static final long serialVersionUID = -1840524349531675772L;
    public static final String KEY_OWNER = "owner";
    protected CronSchedule m_Schedule;
    protected Scheduler m_Scheduler;
    protected transient Flow m_Flow;
    protected AbstractTrigger m_Trigger;

    public String globalInfo() {
        return "Executes the base trigger according to the specified schedule.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("schedule", "schedule", (Object)new CronSchedule("0 0 1 * * ?"));
        this.m_OptionManager.add("trigger", "trigger", (Object)new Null());
    }

    public void setSchedule(CronSchedule value) {
        this.m_Schedule = value;
        this.reset();
    }

    public CronSchedule getSchedule() {
        return this.m_Schedule;
    }

    public String scheduleTipText() {
        return "The schedule for execution the cron actor; format 'SECOND MINUTE HOUR DAYOFMONTH MONTH WEEKDAY [YEAR]'.";
    }

    public void setTrigger(AbstractTrigger value) {
        this.m_Trigger = value;
        this.reset();
    }

    public AbstractTrigger getTrigger() {
        return this.m_Trigger;
    }

    public String triggerTipText() {
        return "The base trigger to execute via the schedule.";
    }

    public Flow getFlow() {
        return this.m_Flow;
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"schedule", (Object)this.m_Schedule.getValue(), (String)"schedule: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"trigger", (Object)this.m_Schedule.getValue(), (String)", trigger: ");
        return result;
    }

    protected String doStart(Flow flow) {
        String result = null;
        this.m_Flow = flow;
        try {
            if (this.m_Scheduler == null) {
                this.m_Scheduler = EventHelper.getDefaultScheduler();
            }
            JobDetail job = new JobDetail(flow.getFlowID() + ".job", flow.getFlowID() + ".group", CronJob.class);
            job.getJobDataMap().put((Object)KEY_OWNER, (Object)this);
            CronTrigger trigger = new CronTrigger(flow.getFlowID() + ".trigger", flow.getFlowID() + ".group", flow.getFlowID() + ".job", flow.getFlowID() + ".group", this.m_Schedule.getValue());
            this.m_Scheduler.addJob(job, true);
            Date first = this.m_Scheduler.scheduleJob((Trigger)trigger);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("First execution of base trigger: " + first);
            }
            this.m_Scheduler.start();
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to set up cron job: ", (Throwable)e);
        }
        return result;
    }

    public String stop() {
        String result = null;
        this.m_Flow = null;
        if (this.m_Scheduler != null) {
            try {
                this.m_Scheduler.shutdown(true);
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Error shutting down scheduler:", (Throwable)e);
            }
        }
        this.m_Trigger.stop();
        return result;
    }

    public static class CronJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            String result = null;
            MetaCron owner = (MetaCron)((Object)context.getJobDetail().getJobDataMap().get((Object)MetaCron.KEY_OWNER));
            if (owner.getTriggerHandler() != null) {
                owner.getTrigger().setTriggerHandler(owner.getTriggerHandler());
                result = owner.getTrigger().start(owner.getFlow());
            }
            if (result != null) {
                owner.getLogger().warning(result);
            }
        }
    }
}

