/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.flow.control.AbstractControlActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.DaemonEvent;
import adams.flow.core.Event;
import adams.flow.core.MutableActorHandler;
import java.util.ArrayList;
import java.util.List;

public class Events
extends AbstractControlActor
implements MutableActorHandler {
    private static final long serialVersionUID = -8393224234458401716L;
    protected List<Actor> m_Actors;

    public String globalInfo() {
        return "Container for event actors.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new ArrayList<Actor>();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actors", (Object)new Actor[0]);
    }

    public String check() {
        String result = super.check();
        if (result == null) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.getScopeHandler() == null) continue;
                result = this.getScopeHandler().addCallableName((ActorHandler)this, this.get(i));
            }
        }
        return result;
    }

    protected Actor checkActor(Actor actor) {
        if (!(actor instanceof Event)) {
            throw new IllegalArgumentException("Only " + Event.class.getName() + " actors are accepted, provided: " + actor.getClass().getName());
        }
        if (this.getScopeHandler() != null && this.getScopeHandler().isCallableNameUsed((ActorHandler)this, actor)) {
            throw new IllegalArgumentException(this.getScopeHandler().addCallableName((ActorHandler)this, actor));
        }
        return actor;
    }

    public void setActors(Actor[] value) {
        ActorUtils.uniqueNames((Actor[])value);
        this.m_Actors.clear();
        for (int i = 0; i < value.length; ++i) {
            this.m_Actors.add(this.checkActor(value[i]));
        }
        this.updateParent();
        this.reset();
    }

    public Actor[] getActors() {
        return this.m_Actors.toArray(new Actor[this.m_Actors.size()]);
    }

    public String actorsTipText() {
        return "The managed events.";
    }

    public int size() {
        return this.m_Actors.size();
    }

    public Actor get(int index) {
        return this.m_Actors.get(index);
    }

    public String set(int index, Actor actor) {
        String result = null;
        if (index > -1 && index < this.m_Actors.size()) {
            ActorUtils.uniqueName((Actor)actor, (ActorHandler)this, (int)index);
            this.m_Actors.set(index, this.checkActor(actor));
            this.reset();
            this.updateParent();
        } else {
            result = "Index out of range (0-" + (this.m_Actors.size() - 1) + "): " + index;
            this.getLogger().severe(result);
        }
        return result;
    }

    public String add(Actor actor) {
        return this.add(this.size(), actor);
    }

    public String add(int index, Actor actor) {
        this.m_Actors.add(index, this.checkActor(actor));
        this.reset();
        this.updateParent();
        return null;
    }

    public Actor remove(int index) {
        Actor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.clear();
        this.reset();
    }

    public int indexOf(String actor) {
        int result = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getName().equals(actor)) continue;
            result = i;
            break;
        }
        return result;
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo().allowStandalones(true).allowSource(true).actorExecution(ActorExecution.UNDEFINED).forwardsInput(false).restrictions(new Class[]{Event.class});
    }

    protected String doExecute() {
        String result = null;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (this.m_Actors.get(i) instanceof DaemonEvent) {
                result = this.m_Actors.get(i).execute();
            }
            if (result != null) break;
        }
        return result;
    }

    public void flushExecution() {
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (this.m_Actors.get(i).getSkip() || !(this.m_Actors.get(i) instanceof ActorHandler)) continue;
            ((ActorHandler)this.m_Actors.get(i)).flushExecution();
        }
    }
}

