/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.menu;

import adams.flow.core.EventHelper;
import adams.gui.action.AbstractBaseAction;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseTableWithButtons;
import adams.gui.core.GUIHelper;
import adams.gui.core.KeyValuePairTableModel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.dialog.TextDialog;
import adams.gui.flow.menu.AbstractFlowEditorMenuItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ShowTriggers
extends AbstractFlowEditorMenuItem {
    private static final long serialVersionUID = 4736251620576615831L;

    public String getMenu() {
        return "View";
    }

    protected KeyValuePairTableModel getTabelModel() {
        KeyValuePairTableModel result = null;
        String[] groups = new String[]{};
        try {
            groups = EventHelper.getDefaultScheduler().getTriggerGroupNames();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to get trigger group names:", (Throwable)e);
            return result;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String group : groups) {
            try {
                String[] triggers;
                for (String trigger : triggers = EventHelper.getDefaultScheduler().getTriggerNames(group)) {
                    list.add(group + "\t" + trigger);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to get trigger names for group '" + group + "':", (Throwable)e);
            }
        }
        Object[][] data = new String[list.size()][2];
        for (int i = 0; i < list.size(); ++i) {
            data[i] = ((String)list.get(i)).split("\t");
        }
        return new KeyValuePairTableModel(data, new String[]{"Group", "Trigger"});
    }

    protected AbstractBaseAction newAction() {
        return new AbstractBaseAction("Show triggers"){
            private static final long serialVersionUID = 868738932723881336L;

            protected void doActionPerformed(ActionEvent e) {
                final BaseTableWithButtons table = new BaseTableWithButtons((TableModel)ShowTriggers.this.getTabelModel());
                final BaseButton viewButton = new BaseButton("View");
                viewButton.setMnemonic('V');
                viewButton.setEnabled(false);
                viewButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int row = table.getSelectedRow();
                        if (row == -1) {
                            return;
                        }
                        TextDialog editor = new TextDialog();
                        editor.setEditable(false);
                        editor.setContent("Group: " + table.getValueAt(row, 0) + "\nTrigger: " + table.getValueAt(row, 1));
                        editor.setSize(GUIHelper.getDefaultTinyDialogDimension());
                        editor.setLocationRelativeTo((Component)table);
                        editor.setVisible(true);
                    }
                });
                table.setAutoResizeMode(0);
                table.setOptimalColumnWidth();
                table.addToButtonsPanel((Component)viewButton);
                table.setDoubleClickButton(viewButton);
                table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        viewButton.setEnabled(table.getSelectedRowCount() == 1);
                    }
                });
                ApprovalDialog dlg = ShowTriggers.this.getOwner().getParentDialog() != null ? ApprovalDialog.getInformationDialog((Dialog)ShowTriggers.this.getOwner().getParentDialog(), (Dialog.ModalityType)Dialog.ModalityType.MODELESS) : ApprovalDialog.getInformationDialog((Frame)ShowTriggers.this.getOwner().getParentFrame(), (boolean)false);
                dlg.setDefaultCloseOperation(2);
                dlg.setTitle("Triggers");
                dlg.getContentPane().add((Component)table);
                dlg.pack();
                dlg.setLocationRelativeTo((Component)ShowTriggers.this.getOwner());
                dlg.setVisible(true);
            }
        };
    }

    public void updateAction() {
        this.m_Action.setEnabled(this.getOwner().isAnyRunning());
    }
}

