/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Variables;
import adams.core.logging.LoggingLevel;
import adams.flow.control.Sequence;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.DaemonEvent;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.Token;
import adams.flow.standalone.AbstractStandalone;
import com.jidesoft.utils.SwingWorker;

public abstract class AbstractMutableActorDaemonEvent<E, P>
extends AbstractStandalone
implements MutableActorHandler,
DaemonEvent {
    private static final long serialVersionUID = 4670761846363281951L;
    public static final String BUSY = "BUSY";
    public static final String NO_OUTPUT = "No output produced";
    protected boolean m_NoDiscard;
    protected Sequence m_Actors;
    protected boolean m_ExecutingActors;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("no-discard", "noDiscard", (Object)false);
        this.m_OptionManager.add("actor", "actors", (Object)new Actor[0]);
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new Sequence();
        this.m_Actors.setAllowSource(true);
        this.m_Actors.setAllowStandalones(true);
    }

    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Actors.setLoggingLevel(value);
    }

    protected void updateParent() {
        this.m_Actors.setParent(null);
        this.m_Actors.setParent(this.getParent());
        this.m_Actors.setName(this.getName());
    }

    public void setNoDiscard(boolean value) {
        this.m_NoDiscard = value;
        this.reset();
    }

    public boolean getNoDiscard() {
        return this.m_NoDiscard;
    }

    public String noDiscardTipText() {
        return "If enabled, no change event gets discarded; CAUTION: enabling this option can slow down the system significantly.";
    }

    protected abstract String checkActors(Actor[] var1);

    public void setActors(Actor[] value) {
        String msg = this.checkActors(value);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public Actor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actors to execute in case of a change event.";
    }

    protected abstract boolean handlesEvent(E var1);

    protected abstract P preProcessEvent(E var1);

    protected abstract boolean usePreProcessedAsInput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processEvent(E e) {
        if (!this.handlesEvent(e)) {
            return null;
        }
        final P preprocessed = this.preProcessEvent(e);
        if (preprocessed == null) {
            return NO_OUTPUT;
        }
        if (this.m_ExecutingActors) {
            if (!this.m_NoDiscard) {
                return BUSY;
            }
            while (this.m_ExecutingActors && !this.isStopped()) {
                try {
                    AbstractMutableActorDaemonEvent abstractMutableActorDaemonEvent = this;
                    synchronized (abstractMutableActorDaemonEvent) {
                        ((Object)((Object)this)).wait(10L);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        if (this.isStopped()) {
            return null;
        }
        this.m_ExecutingActors = true;
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                if (AbstractMutableActorDaemonEvent.this.usePreProcessedAsInput()) {
                    AbstractMutableActorDaemonEvent.this.m_Actors.input(new Token(preprocessed));
                }
                String result = AbstractMutableActorDaemonEvent.this.m_Actors.execute();
                return result;
            }

            protected void done() {
                super.done();
                AbstractMutableActorDaemonEvent.this.m_ExecutingActors = false;
            }
        };
        worker.execute();
        return null;
    }

    public int size() {
        return this.m_Actors.size();
    }

    public Actor get(int index) {
        return this.m_Actors.get(index);
    }

    public String set(int index, Actor actor) {
        String result = this.m_Actors.set(index, actor);
        this.reset();
        this.updateParent();
        return result;
    }

    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    public String add(Actor actor) {
        return this.add(this.size(), actor);
    }

    public String add(int index, Actor actor) {
        if (actor == this) {
            throw new IllegalArgumentException("Cannot add itself!");
        }
        String result = this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
        return result;
    }

    public Actor remove(int index) {
        Actor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    public int active() {
        return this.m_Actors.active();
    }

    public Actor firstActive() {
        return this.m_Actors.firstActive();
    }

    public Actor lastActive() {
        return this.m_Actors.lastActive();
    }

    public String check() {
        String result = this.m_Actors.check();
        if (result == null) {
            result = this.checkActors(this.m_Actors.getActors());
        }
        return result;
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setVariables(value);
        }
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.updateParent();
            result = this.m_Actors.setUp();
        }
        return result;
    }

    protected String doExecute() {
        return null;
    }

    public void flushExecution() {
        if (this.m_Actors != null) {
            this.m_Actors.flushExecution();
        }
    }

    public void stopExecution() {
        this.m_Actors.stopExecution();
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_Actors != null) {
            this.m_Actors.wrapUp();
        }
        super.wrapUp();
    }

    public void cleanUp() {
        if (this.m_Actors != null) {
            this.m_Actors.cleanUp();
        }
        super.cleanUp();
    }
}

