/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.base.CronSchedule;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.True;
import adams.flow.control.Sequence;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.DaemonEvent;
import adams.flow.core.EventHelper;
import adams.flow.core.MutableActorHandler;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.template.EndlessLoop;
import java.util.Date;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.Trigger;

public class Cron
extends AbstractStandalone
implements MutableActorHandler,
DaemonEvent {
    private static final long serialVersionUID = 4670761846363281951L;
    public static final String KEY_OWNER = "owner";
    public static final String BUSY = "BUSY";
    protected Sequence m_CronActors;
    protected CronSchedule m_Schedule;
    protected Scheduler m_Scheduler;
    protected boolean m_ExecutingCronActors;

    public String globalInfo() {
        return "Executes an actor according to a pre-defined schedule.\nNote: since the actor merely starts the cron scheduler in the background, the actor finishes the execution pretty much immediately. Therefore, the flow needs to be kept alive in order to let the background jobs getting executed. This can be done with a simple WhileLoop actor using the '" + True.class.getName() + "' condition and a nested Start/Sleep actor. You can use the " + EndlessLoop.class.getName() + "template to generate this loop automatically.\n\nNB: Any newly scheduled jobs get dropped if the previous execution is still running.\n\nFor more information on the scheduler format see:\nhttp://www.quartz-scheduler.org/docs/tutorials/crontrigger.html";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cron-actor", "cronActors", (Object)new Actor[0]);
        this.m_OptionManager.add("schedule", "schedule", (Object)new CronSchedule("0 0 1 * * ?"));
    }

    protected void initialize() {
        super.initialize();
        this.m_CronActors = new Sequence();
        this.m_CronActors.setAllowSource(true);
        this.m_CronActors.setAllowStandalones(true);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"schedule", (Object)this.m_Schedule.getValue());
    }

    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_CronActors.setLoggingLevel(value);
    }

    protected String checkCronActors(Actor[] actors) {
        return null;
    }

    protected void updateParent() {
        this.m_CronActors.setParent(null);
        this.m_CronActors.setParent(this.getParent());
        this.m_CronActors.setName(this.getName());
    }

    public void setCronActors(Actor[] value) {
        String msg = this.checkCronActors(value);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_CronActors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public Actor[] getCronActors() {
        return this.m_CronActors.getActors();
    }

    public String cronActorsTipText() {
        return "The actor to execute according to the cron schedule.";
    }

    public void setSchedule(CronSchedule value) {
        this.m_Schedule = value;
        this.reset();
    }

    public CronSchedule getSchedule() {
        return this.m_Schedule;
    }

    public String scheduleTipText() {
        return "The schedule for execution the cron actor; format 'SECOND MINUTE HOUR DAYOFMONTH MONTH WEEKDAY [YEAR]'.";
    }

    protected String executeCronActors() {
        if (this.m_ExecutingCronActors) {
            return BUSY;
        }
        this.m_ExecutingCronActors = true;
        String result = this.m_CronActors.execute();
        this.m_ExecutingCronActors = false;
        return result;
    }

    public int size() {
        return this.m_CronActors.size();
    }

    public Actor get(int index) {
        return this.m_CronActors.get(index);
    }

    public String set(int index, Actor actor) {
        String result = this.m_CronActors.set(index, actor);
        this.reset();
        this.updateParent();
        return result;
    }

    public int indexOf(String actor) {
        return this.m_CronActors.indexOf(actor);
    }

    public String add(Actor actor) {
        return this.add(this.size(), actor);
    }

    public String add(int index, Actor actor) {
        if (actor == this) {
            throw new IllegalArgumentException("Cannot add itself!");
        }
        String result = this.m_CronActors.add(index, actor);
        this.reset();
        this.updateParent();
        return result;
    }

    public Actor remove(int index) {
        Actor result = this.m_CronActors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_CronActors.removeAll();
        this.reset();
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_CronActors.getActorHandlerInfo();
    }

    public int active() {
        return this.m_CronActors.active();
    }

    public Actor firstActive() {
        return this.m_CronActors.firstActive();
    }

    public Actor lastActive() {
        return this.m_CronActors.lastActive();
    }

    public String check() {
        return this.m_CronActors.check();
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        this.m_CronActors.setVariables(value);
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setVariables(value);
        }
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.updateParent();
            result = this.m_CronActors.setUp();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_Scheduler == null) {
                this.m_Scheduler = EventHelper.getDefaultScheduler();
            }
            JobDetail job = new JobDetail(this.getFullName() + ".job", this.getFullName() + ".group", CronJob.class);
            job.getJobDataMap().put((Object)KEY_OWNER, (Object)this);
            CronTrigger trigger = new CronTrigger(this.getFullName() + ".trigger", this.getFullName() + ".group", this.getFullName() + ".job", this.getFullName() + ".group", this.m_Schedule.getValue());
            this.m_Scheduler.addJob(job, true);
            Date first = this.m_Scheduler.scheduleJob((Trigger)trigger);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("First execution of actor: " + first);
            }
            this.m_Scheduler.start();
        }
        catch (Exception e) {
            result = this.handleException("Failed to set up cron job: ", e);
        }
        return result;
    }

    protected void stopScheduler() {
        if (this.m_Scheduler != null) {
            try {
                this.m_Scheduler.shutdown(true);
            }
            catch (Exception e) {
                this.handleException("Error shutting down scheduler:", e);
            }
        }
    }

    public void flushExecution() {
        if (this.m_CronActors != null) {
            this.m_CronActors.flushExecution();
        }
    }

    public void stopExecution() {
        this.stopScheduler();
        this.m_CronActors.stopExecution();
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_CronActors != null) {
            this.m_CronActors.wrapUp();
        }
        this.stopScheduler();
        super.wrapUp();
    }

    public void cleanUp() {
        if (this.m_CronActors != null) {
            this.m_CronActors.cleanUp();
        }
        super.cleanUp();
    }

    public static class CronJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            Cron owner = (Cron)((Object)context.getJobDetail().getJobDataMap().get((Object)Cron.KEY_OWNER));
            String result = owner.executeCronActors();
            if (result != null) {
                if (!result.equals(Cron.BUSY)) {
                    result = owner.getErrorHandler().handleError((Actor)owner, "execute/cron", owner.getFullName() + ": " + result);
                    if (result != null) {
                        throw new JobExecutionException(owner.getFullName() + ": " + result);
                    }
                } else if (owner.isLoggingEnabled()) {
                    owner.getLogger().info("Job dropped since still executing previous job: " + context.getJobDetail());
                }
            }
        }
    }
}

