/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionHandler;
import adams.flow.control.Sequence;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.TriggerableEvent;
import adams.flow.standalone.AbstractStandalone;

public class DelayedEvent
extends AbstractStandalone
implements MutableActorHandler,
TriggerableEvent {
    private static final long serialVersionUID = 4670761846363281951L;
    protected Sequence m_Actors;
    protected int m_Delay;

    public String globalInfo() {
        return "Executes its sub-flow after a predefined number of milli-seconds.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actors", (Object)new Actor[0]);
        this.m_OptionManager.add("delay", "delay", (Object)1000, (Number)1, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new Sequence();
        this.m_Actors.setAllowSource(true);
        this.m_Actors.setAllowStandalones(true);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"delay", (Object)this.m_Delay) + "ms";
    }

    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Actors.setLoggingLevel(value);
    }

    protected String checkActors(Actor[] actors) {
        return null;
    }

    protected void updateParent() {
        this.m_Actors.setParent(null);
        this.m_Actors.setParent(this.getParent());
        this.m_Actors.setName(this.getName());
    }

    public void setActors(Actor[] value) {
        String msg = this.checkActors(value);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public Actor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actors to execute after the delay.";
    }

    public void setDelay(int value) {
        this.m_Delay = value;
        this.reset();
    }

    public int getDelay() {
        return this.m_Delay;
    }

    public String delayTipText() {
        return "The delay in msecs before executing the sub-flow.";
    }

    public int size() {
        return this.m_Actors.size();
    }

    public Actor get(int index) {
        return this.m_Actors.get(index);
    }

    public String set(int index, Actor actor) {
        String result = this.m_Actors.set(index, actor);
        this.reset();
        this.updateParent();
        return result;
    }

    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    public String add(Actor actor) {
        return this.add(this.size(), actor);
    }

    public String add(int index, Actor actor) {
        if (actor == this) {
            throw new IllegalArgumentException("Cannot add itself!");
        }
        String result = this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
        return result;
    }

    public Actor remove(int index) {
        Actor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    public int active() {
        return this.m_Actors.active();
    }

    public Actor firstActive() {
        return this.m_Actors.firstActive();
    }

    public Actor lastActive() {
        return this.m_Actors.lastActive();
    }

    public String check() {
        return this.m_Actors.check();
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setVariables(value);
        }
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.updateParent();
            result = this.m_Actors.setUp();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        long stopTime = System.currentTimeMillis() + (long)this.m_Delay;
        while (stopTime > System.currentTimeMillis() && !this.isStopped()) {
            try {
                DelayedEvent delayedEvent = this;
                synchronized (delayedEvent) {
                    ((Object)((Object)this)).wait(50L);
                }
            }
            catch (Exception exception) {
            }
        }
        if (!this.isStopped()) {
            result = this.m_Actors.execute();
        }
        return result;
    }

    public void flushExecution() {
        if (this.m_Actors != null) {
            this.m_Actors.flushExecution();
        }
    }

    public void stopExecution() {
        this.m_Actors.stopExecution();
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_Actors != null) {
            this.m_Actors.wrapUp();
        }
        super.wrapUp();
    }

    public void cleanUp() {
        if (this.m_Actors != null) {
            this.m_Actors.cleanUp();
        }
        super.cleanUp();
    }
}

