/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.logevent;

import adams.core.Properties;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.db.LogEntry;
import adams.flow.standalone.logevent.AbstractLogRecordProcessor;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogEntryProcessor
extends AbstractLogRecordProcessor<LogEntry> {
    private static final long serialVersionUID = -5912851978968280646L;

    public String globalInfo() {
        return "Turns the log record into a log entry.";
    }

    @Override
    public LogEntry processRecord(LogRecord record) {
        LogEntry result = new LogEntry();
        String msg = record.getMessage() + "\n";
        if (record.getThrown() != null) {
            msg = msg + LoggingHelper.throwableToString((Throwable)record.getThrown()) + "\n";
        }
        Properties props = new Properties();
        props.setProperty("Message", msg);
        result.setGeneration(new Date());
        result.setSource(record.getLoggerName());
        result.setType(LoggingLevel.valueOf((Level)record.getLevel()).toString());
        result.setStatus("New");
        result.setMessage(props);
        return result;
    }

    @Override
    public Class generates() {
        return LogEntry.class;
    }
}

