/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.logging.LoggingObject;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.EventReference;
import adams.flow.core.ExternalActorHandler;
import adams.flow.standalone.Events;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class EventHelper
extends LoggingObject {
    private static final long serialVersionUID = -763479272812116920L;
    protected static transient Map<Integer, StdSchedulerFactory> m_SchedulerFactory;

    public Actor findEvent(ActorHandler group, EventReference name) {
        Actor result = null;
        for (int i = 0; i < group.size(); ++i) {
            ExternalActorHandler external;
            if (group.get(i) instanceof Events) {
                Events global = (Events)group.get(i);
                int index = global.indexOf(name.toString());
                if (index <= -1) continue;
                result = global.get(index);
                break;
            }
            if (group.get(i) instanceof ExternalActorHandler && (external = (ExternalActorHandler)group.get(i)).getExternalActor() instanceof ActorHandler && (result = this.findEvent((ActorHandler)external.getExternalActor(), name)) != null) break;
        }
        return result;
    }

    public Actor findEvent(Actor root, EventReference name) {
        Actor result = null;
        if (root == null) {
            this.getLogger().severe("No root container found!");
        } else if (!(root instanceof AbstractDirectedControlActor)) {
            this.getLogger().severe("Root is not a container ('" + root.getFullName() + "'/" + root.getClass().getName() + ")!");
            root = null;
        }
        if (root != null) {
            result = this.findEvent((ActorHandler)root, name);
        }
        return result;
    }

    public Actor findEventRecursive(Actor actor, EventReference name) {
        Actor result = null;
        List handlers = ActorUtils.findActorHandlers((Actor)actor, (boolean)true);
        for (int i = 0; i < handlers.size() && (result = this.findEvent((ActorHandler)handlers.get(i), name)) == null; ++i) {
        }
        return result;
    }

    public static synchronized Scheduler getDefaultScheduler(int flowID) throws SchedulerException {
        if (m_SchedulerFactory == null) {
            m_SchedulerFactory = new HashMap<Integer, StdSchedulerFactory>();
        }
        if (!m_SchedulerFactory.containsKey(flowID)) {
            adams.core.Properties defaultProps = new adams.core.Properties();
            adams.core.Properties.loadFromResource((adams.core.Properties)defaultProps, (String)"org/quartz/quartz.properties");
            adams.core.Properties userProps1 = new adams.core.Properties(defaultProps);
            adams.core.Properties.loadFromResource((adams.core.Properties)userProps1, (String)"quartz.properties");
            adams.core.Properties userProps2 = new adams.core.Properties(userProps1);
            adams.core.Properties.loadFromResource((adams.core.Properties)userProps2, (String)"quartz.props");
            adams.core.Properties props = userProps2;
            props.setProperty("org.quartz.scheduler.skipUpdateCheck", "true");
            props.setProperty("org.quartz.scheduler.instanceName", "QuartzScheduler-" + flowID);
            m_SchedulerFactory.put(flowID, new StdSchedulerFactory((Properties)props));
        }
        return m_SchedulerFactory.get(flowID).getScheduler();
    }
}

