/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.logging.AbstractLogHandler;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingListener;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.Compatibility;
import adams.flow.core.DaemonEvent;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.standalone.AbstractMutableActorDaemonEvent;
import adams.flow.standalone.logevent.AbstractLogRecordFilter;
import adams.flow.standalone.logevent.AbstractLogRecordProcessor;
import adams.flow.standalone.logevent.AcceptAllFilter;
import adams.flow.standalone.logevent.SimpleProcessor;
import java.util.logging.LogRecord;

public class LogEvent
extends AbstractMutableActorDaemonEvent<LogRecord, Object>
implements MutableActorHandler,
DaemonEvent,
LoggingListener {
    private static final long serialVersionUID = 4670761846363281951L;
    protected AbstractLogRecordFilter m_Filter;
    protected AbstractLogRecordProcessor m_Processor;

    public String globalInfo() {
        return "Listens to the global log record handler and processes records that passed the specified filter(s).\nThis allows, for instance, the output of log messages into a log file.\nBy default, log records are only processed if the sub-actors are not currently being executed. In other words, log records will get dropped if the record processing takes longer than the record generation. Enable the 'noDiscard' property to process all log events - NB: this can slow down the system significantly.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new AcceptAllFilter());
        this.m_OptionManager.add("processor", "processor", (Object)new SimpleProcessor());
    }

    @Override
    protected String checkActors(Actor[] actors) {
        Compatibility comp = new Compatibility();
        for (int i = 0; i < actors.length; ++i) {
            if (actors[i].getSkip()) continue;
            if (!(actors[i] instanceof InputConsumer)) {
                return "Actor #" + (i + 1) + " does not accept input!";
            }
            if (comp.isCompatible(new Class[]{this.m_Processor.generates()}, ((InputConsumer)actors[i]).accepts())) break;
            return "Actor #" + (i + 1) + " does not accept the processor's output: " + Utils.classToString((Class)this.m_Processor.generates());
        }
        return null;
    }

    public void setFilter(AbstractLogRecordFilter value) {
        this.m_Filter = value;
        this.reset();
    }

    public AbstractLogRecordFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter used for selecting log records for processing.";
    }

    public void setProcessor(AbstractLogRecordProcessor value) {
        this.m_Processor = value;
        this.reset();
    }

    public AbstractLogRecordProcessor getProcessor() {
        return this.m_Processor;
    }

    public String processorTipText() {
        return "The processor used for turning the log record into a different format.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)((Object)this.m_Filter), (String)"filter: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"processor", (Object)((Object)this.m_Processor), (String)", processor: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"noDiscard", (boolean)this.m_NoDiscard, (String)"no discard", (String)", ");
        if (value != null) {
            result = (String)result + value;
        }
        return result;
    }

    @Override
    protected boolean handlesEvent(LogRecord e) {
        return this.m_Filter.acceptRecord(e);
    }

    @Override
    protected Object preProcessEvent(LogRecord e) {
        return this.m_Processor.processRecord(e);
    }

    @Override
    protected boolean usePreProcessedAsInput() {
        return true;
    }

    @Override
    public String setUp() {
        Object result = super.setUp();
        if (result == null && (result = this.m_Actors.setUp()) == null) {
            if (!(LoggingHelper.getDefaultHandler() instanceof AbstractLogHandler)) {
                result = "Default logging handler (" + LoggingHelper.getDefaultHandler().getClass().getName() + ") is not derived from " + AbstractLogHandler.class.getName() + "!";
            } else {
                ((AbstractLogHandler)LoggingHelper.getDefaultHandler()).addLoggingListener((LoggingListener)this);
            }
        }
        return result;
    }

    public void logEventOccurred(AbstractLogHandler source, LogRecord record) {
        if (!this.isStopped()) {
            this.processEvent(record);
        }
    }

    @Override
    public void wrapUp() {
        if (LoggingHelper.getDefaultHandler() instanceof AbstractLogHandler) {
            ((AbstractLogHandler)LoggingHelper.getDefaultHandler()).removeLoggingListener((LoggingListener)this);
        }
        super.wrapUp();
    }
}

