/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Index;
import adams.core.Range;
import adams.data.io.input.AbstractSpreadSheetReaderWithMissingValueSupport;

public abstract class AbstractExcelSpreadSheetReader
extends AbstractSpreadSheetReaderWithMissingValueSupport {
    private static final long serialVersionUID = 4755872204697328246L;
    protected Index m_SheetIndex;
    protected boolean m_AutoExtendHeader;
    protected Range m_TextColumns;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sheet", "sheetIndex", (Object)new Index("first"));
        this.m_OptionManager.add("no-auto-extend-header", "autoExtendHeader", (Object)true);
        this.m_OptionManager.add("text-columns", "textColumns", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_SheetIndex = new Index();
        this.m_TextColumns = new Range();
    }

    public void setSheetIndex(Index value) {
        this.m_SheetIndex = value;
        this.reset();
    }

    public Index getSheetIndex() {
        return this.m_SheetIndex;
    }

    public String sheetIndexTipText() {
        return "The index of the sheet to load; " + this.m_SheetIndex.getExample();
    }

    public void setAutoExtendHeader(boolean value) {
        this.m_AutoExtendHeader = value;
        this.reset();
    }

    public boolean getAutoExtendHeader() {
        return this.m_AutoExtendHeader;
    }

    public String autoExtendHeaderTipText() {
        return "If enabled, the header gets automatically extended if rows have more cells than the header.";
    }

    public void setTextColumns(String value) {
        this.m_TextColumns.setRange(value);
        this.reset();
    }

    public String getTextColumns() {
        return this.m_TextColumns.getRange();
    }

    public String textColumnsTipText() {
        return "The range of columns to treat as text; " + this.m_TextColumns.getExample();
    }
}

