/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.data.io.input.AbstractExcelSpreadSheetReader;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelSpreadSheetReader
extends AbstractExcelSpreadSheetReader {
    private static final long serialVersionUID = 4755872204697328246L;

    public String globalInfo() {
        return "Reads MS Excel files (using DOM).";
    }

    public String getFormatDescription() {
        return "MS Excel spreadsheets";
    }

    public String[] getFormatExtensions() {
        return new String[]{"xls", "xlsx"};
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.STREAM;
    }

    protected String numericToString(Cell cell) {
        Double dbl = cell.getNumericCellValue();
        long lng = dbl.longValue();
        if (dbl == (double)lng) {
            return "" + lng;
        }
        return "" + dbl;
    }

    protected SpreadSheet doRead(InputStream in) {
        SpreadSheet result = new SpreadSheet();
        result.setDataRowClass(this.m_DataRowType.getRowClass());
        Workbook workbook = null;
        DateFormat dformat = DateUtils.getTimestampFormatter();
        try {
            boolean numeric;
            Cell exCell;
            int i;
            workbook = WorkbookFactory.create((InputStream)in);
            this.m_SheetIndex.setMax(workbook.getNumberOfSheets());
            Sheet sheet = workbook.getSheetAt(this.m_SheetIndex.getIntIndex());
            if (sheet.getLastRowNum() == 0) {
                this.getSystemErr().println("No rows in sheet #" + this.m_SheetIndex.getIndex());
                return result;
            }
            result.setName(sheet.getSheetName());
            Row exRow = sheet.getRow(0);
            HeaderRow spRow = result.getHeaderRow();
            this.m_TextColumns.setMax((int)exRow.getLastCellNum());
            block10: for (i = 0; i < exRow.getLastCellNum() && !this.m_Stopped; ++i) {
                exCell = exRow.getCell(i);
                if (exCell == null) {
                    spRow.addCell("" + (i + 1)).setContent("?");
                    continue;
                }
                numeric = !this.m_TextColumns.isInRange(i);
                switch (exCell.getCellType()) {
                    case 3: 
                    case 5: {
                        spRow.addCell("" + (i + 1)).setContent("column-" + (i + 1));
                        continue block10;
                    }
                    case 0: {
                        if (HSSFDateUtil.isCellDateFormatted((Cell)exCell)) {
                            spRow.addCell("" + (i + 1)).setContent(HSSFDateUtil.getJavaDate((double)exCell.getNumericCellValue()));
                            continue block10;
                        }
                        if (numeric) {
                            spRow.addCell("" + (i + 1)).setContent(Double.valueOf(exCell.getNumericCellValue()));
                            continue block10;
                        }
                        spRow.addCell("" + (i + 1)).setContentAsString(this.numericToString(exCell));
                        continue block10;
                    }
                    default: {
                        spRow.addCell("" + (i + 1)).setContentAsString(exCell.getStringCellValue());
                    }
                }
            }
            for (i = 1; i <= sheet.getLastRowNum() && !this.m_Stopped; ++i) {
                spRow = result.addRow("" + result.getRowCount());
                exRow = sheet.getRow(i);
                if (exRow == null) continue;
                block12: for (int n = 0; n < exRow.getLastCellNum(); ++n) {
                    if (n >= result.getHeaderRow().getCellCount() && this.m_AutoExtendHeader) {
                        result.getHeaderRow().addCell("" + n).setContent("");
                    }
                    this.m_TextColumns.setMax(result.getHeaderRow().getCellCount());
                    exCell = exRow.getCell(n);
                    if (exCell == null) {
                        spRow.addCell("" + (n + 1)).setContent("?");
                        continue;
                    }
                    int cellType = exCell.getCellType();
                    if (cellType == 2) {
                        cellType = exCell.getCachedFormulaResultType();
                    }
                    numeric = !this.m_TextColumns.isInRange(n);
                    switch (cellType) {
                        case 3: 
                        case 5: {
                            if (this.m_MissingValue.length() == 0) {
                                spRow.addCell("" + (n + 1)).setContent("?");
                                continue block12;
                            }
                            spRow.addCell("" + (n + 1)).setContent("");
                            continue block12;
                        }
                        case 0: {
                            if (HSSFDateUtil.isCellDateFormatted((Cell)exCell)) {
                                spRow.addCell("" + (n + 1)).setContent(dformat.format(HSSFDateUtil.getJavaDate((double)exCell.getNumericCellValue())));
                                continue block12;
                            }
                            if (numeric) {
                                spRow.addCell("" + (n + 1)).setContent(Double.valueOf(exCell.getNumericCellValue()));
                                continue block12;
                            }
                            spRow.addCell("" + (n + 1)).setContentAsString(this.numericToString(exCell));
                            continue block12;
                        }
                        default: {
                            if (exCell.getStringCellValue().equals(this.m_MissingValue)) {
                                spRow.addCell("" + (n + 1)).setContent("?");
                                continue block12;
                            }
                            spRow.addCell("" + (n + 1)).setContentAsString(exCell.getStringCellValue());
                        }
                    }
                }
            }
        }
        catch (Exception ioe) {
            this.getSystemErr().println("Failed to read header:");
            this.getSystemErr().printStackTrace((Throwable)ioe);
            result = null;
        }
        return result;
    }
}

