/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.DateTime;
import adams.core.ExcelHelper;
import adams.core.License;
import adams.core.Time;
import adams.core.annotation.MixedCopyright;
import adams.data.io.input.AbstractExcelSpreadSheetReader;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

@MixedCopyright(copyright="Apache Foundation", license=License.APACHE2, url="http://poi.apache.org/spreadsheet/how-to.html#xssf_sax_api", note="Adapted example from Apache website")
public class ExcelSAXSpreadSheetReader
extends AbstractExcelSpreadSheetReader {
    private static final long serialVersionUID = 4755872204697328246L;

    public String globalInfo() {
        return "Reads large MS Excel XML files (using SAX).";
    }

    public String getFormatDescription() {
        return "MS Excel spreadsheets (large XML)";
    }

    public String[] getFormatExtensions() {
        return new String[]{"xlsx"};
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.FILE;
    }

    protected SpreadSheet doRead(File file) {
        SpreadSheet result = new SpreadSheet();
        result.setDataRowClass(this.m_DataRowType.getRowClass());
        try {
            OPCPackage pkg = OPCPackage.open((String)file.getAbsolutePath());
            XSSFReader reader = new XSSFReader(pkg);
            SharedStringsTable sst = reader.getSharedStringsTable();
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            SheetHandler handler = new SheetHandler(this, result, sst);
            parser.setContentHandler(handler);
            Iterator sheets = reader.getSheetsData();
            int count = 0;
            while (sheets.hasNext() && !this.m_Stopped) {
                this.m_SheetIndex.setMax(count + 1);
                InputStream sheet = (InputStream)sheets.next();
                if (this.m_SheetIndex.getIntIndex() == count) {
                    InputSource sheetSource = new InputSource(sheet);
                    parser.parse(sheetSource);
                }
                sheet.close();
                ++count;
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace("Failed to read spreadsheet:", (Throwable)e);
        }
        return result;
    }

    @MixedCopyright(copyright="Apache Foundation", license=License.APACHE2, url="http://poi.apache.org/spreadsheet/how-to.html#xssf_sax_api", note="Adapted example from Apache website")
    public static class SheetHandler
    extends DefaultHandler {
        protected ExcelSAXSpreadSheetReader m_Owner;
        protected SpreadSheet m_Sheet;
        protected SharedStringsTable m_SST;
        protected StringBuilder m_LastContents;
        protected Cell.ContentType m_ContentType;
        protected String m_Reference;
        protected HashSet<String> m_UnhandledCellTypes;

        public SheetHandler(ExcelSAXSpreadSheetReader owner, SpreadSheet sheet, SharedStringsTable sst) {
            this.m_Owner = owner;
            this.m_Sheet = sheet;
            this.m_SST = sst;
            this.m_LastContents = new StringBuilder();
            this.m_Reference = "";
            this.m_ContentType = Cell.ContentType.MISSING;
            this.m_UnhandledCellTypes = new HashSet();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("c")) {
                this.m_Reference = attributes.getValue("r");
                String cellType = attributes.getValue("t");
                String cellStr = attributes.getValue("s");
                this.m_ContentType = Cell.ContentType.MISSING;
                this.m_ContentType = "s".equals(cellType) ? Cell.ContentType.STRING : ("b".equals(cellType) ? Cell.ContentType.BOOLEAN : ("e".equals(cellStr) ? null : ("2".equals(cellStr) ? Cell.ContentType.DATE : ("3".equals(cellStr) ? Cell.ContentType.TIME : ("4".equals(cellStr) ? Cell.ContentType.DATETIME : Cell.ContentType.DOUBLE)))));
            }
            if (this.m_LastContents.length() > 0) {
                this.m_LastContents.delete(0, this.m_LastContents.length());
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.m_ContentType) {
                case STRING: {
                    int idx = Integer.parseInt(this.m_LastContents.toString());
                    this.m_LastContents = new StringBuilder(new XSSFRichTextString(this.m_SST.getEntryAt(idx)).toString());
                }
            }
            if (name.equals("v")) {
                try {
                    String content = this.m_LastContents.toString();
                    int[] loc = ExcelHelper.getCellLocation(this.m_Reference);
                    while (this.m_Sheet.getRowCount() < loc[0]) {
                        this.m_Sheet.addRow();
                    }
                    while (this.m_Sheet.getColumnCount() <= loc[1]) {
                        this.m_Sheet.insertColumn(this.m_Sheet.getColumnCount(), "col" + (this.m_Sheet.getColumnCount() + 1));
                    }
                    if (loc[0] == 0) {
                        HeaderRow row = this.m_Sheet.getHeaderRow();
                        Cell cell = row.addCell(loc[1]);
                        if (content.equals(this.m_Owner.getMissingValue())) {
                            cell.setMissing();
                        } else {
                            cell.setContent(content);
                        }
                    } else {
                        DataRow row = this.m_Sheet.getRow(loc[0] - 1);
                        Cell cell = row.addCell(loc[1]);
                        if (content.equals(this.m_Owner.getMissingValue())) {
                            cell.setMissing();
                        } else if (this.m_ContentType == null) {
                            cell.setContent(content);
                        } else {
                            switch (this.m_ContentType) {
                                case STRING: {
                                    cell.setContentAsString(content);
                                    break;
                                }
                                case BOOLEAN: {
                                    cell.setContent(new Boolean(!content.equals("0")));
                                    break;
                                }
                                case DATE: {
                                    cell.setContent(DateUtil.getJavaDate((double)Long.parseLong(content)));
                                    break;
                                }
                                case DATETIME: {
                                    cell.setContent(new DateTime(DateUtil.getJavaDate((double)Double.parseDouble(content))));
                                    break;
                                }
                                case TIME: {
                                    cell.setContent(new Time(DateUtil.getJavaDate((double)Double.parseDouble(content))));
                                    break;
                                }
                                case DOUBLE: {
                                    cell.setContent(new Double(content));
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.m_Owner.getSystemErr().printStackTrace("Failed to set cell content at " + this.m_Reference + " (rows=" + this.m_Sheet.getRowCount() + ", cols=" + this.m_Sheet.getColumnCount() + "):", (Throwable)e);
                }
            }
            this.m_ContentType = Cell.ContentType.MISSING;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.m_LastContents.append(ch, start, length);
        }
    }
}

