/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Index;
import adams.data.io.input.ExcelSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.tools.previewbrowser.AbstractSpreadSheetHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelSpreadSheetHandler
extends AbstractSpreadSheetHandler {
    private static final long serialVersionUID = -3962259305718630395L;

    public String[] getExtensions() {
        return new String[]{"xls", "xlsx"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSheetCount(File file) {
        int result;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
            Workbook workbook = WorkbookFactory.create((InputStream)input);
            result = workbook.getNumberOfSheets();
        }
        catch (Exception e) {
            result = 0;
            this.getSystemErr().println("Failed to determine sheet count for '" + file + "':");
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    protected SpreadSheet[] readAll(File file) {
        Vector<SpreadSheet> result = new Vector<SpreadSheet>();
        int count = this.getSheetCount(file);
        ExcelSpreadSheetReader reader = new ExcelSpreadSheetReader();
        for (int i = 0; i < count; ++i) {
            reader.setSheetIndex(new Index("" + (i + 1)));
            SpreadSheet sheet = reader.read(file);
            if (sheet == null) continue;
            result.add(sheet);
        }
        return result.toArray(new SpreadSheet[result.size()]);
    }
}

