/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.ExcelHelper;
import adams.core.Utils;
import adams.data.io.output.AbstractMultiSheetSpreadSheetWriterWithMissingValueSupport;
import adams.data.io.output.SpreadSheetWriterWithFormulaSupport;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelStreamingSpreadSheetWriter
extends AbstractMultiSheetSpreadSheetWriterWithMissingValueSupport
implements SpreadSheetWriterWithFormulaSupport {
    private static final long serialVersionUID = -3549185519778801930L;
    public static String FILE_EXTENSION = ".xlsx";
    protected boolean m_OutputAsDisplayed;
    protected int m_MaxRows;

    public String globalInfo() {
        return "Writes OOXML MS Excel files in streaming mode (more memory efficient).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-as-displayed", "outputAsDisplayed", (Object)false);
        this.m_OptionManager.add("max-rows", "maxRows", (Object)100, (Number)1, null);
    }

    public String getFormatDescription() {
        return "MS Excel spreadsheets (large XML)";
    }

    public String[] getFormatExtensions() {
        return new String[]{".xslx"};
    }

    protected boolean getUseOutputStream() {
        return true;
    }

    public void setOutputAsDisplayed(boolean value) {
        this.m_OutputAsDisplayed = value;
        this.reset();
    }

    public boolean getOutputAsDisplayed() {
        return this.m_OutputAsDisplayed;
    }

    public String outputAsDisplayedTipText() {
        return "If enabled, cells are output as displayed, ie, results of formulas instead of the formulas.";
    }

    public void setMaxRows(int value) {
        if (value > 0) {
            this.m_MaxRows = value;
            this.reset();
        } else {
            this.getSystemErr().println("At least 1 rows needs to be kept in memory, provided: " + value);
        }
    }

    public int getMaxRows() {
        return this.m_MaxRows;
    }

    public String maxRowsTipText() {
        return "The maximum number of rows to keep in memory.";
    }

    protected boolean doWrite(SpreadSheet[] content, OutputStream out) {
        boolean result = true;
        try {
            SXSSFWorkbook workbook = new SXSSFWorkbook(this.m_MaxRows);
            CellStyle styleDate = ExcelHelper.getDateCellStyle((Workbook)workbook, "yyyy-MM-dd");
            CellStyle styleDateTime = ExcelHelper.getDateCellStyle((Workbook)workbook, "yyyy-MM-dd HH:mm:ss");
            CellStyle styleTime = ExcelHelper.getDateCellStyle((Workbook)workbook, "HH:mm:ss");
            int count = 0;
            for (SpreadSheet cont : content) {
                Cell cell;
                int i;
                Sheet sheet = workbook.createSheet();
                workbook.setSheetName(count, this.m_SheetPrefix + (count + 1));
                Row row = sheet.createRow(0);
                for (i = 0; i < cont.getColumnCount(); ++i) {
                    cell = row.createCell(i);
                    cell.setCellValue(cont.getHeaderRow().getCell(i).getContent());
                }
                for (int n = 0; n < cont.getRowCount(); ++n) {
                    row = sheet.createRow(n + 1);
                    DataRow spRow = cont.getRow(n);
                    for (i = 0; i < cont.getColumnCount(); ++i) {
                        cell = row.createCell(i);
                        adams.data.spreadsheet.Cell spCell = spRow.getCell(i);
                        if (spCell == null || spCell.isMissing()) {
                            if (this.m_MissingValue.length() > 0) {
                                cell.setCellValue(this.m_MissingValue);
                                continue;
                            }
                            cell.setCellType(3);
                            continue;
                        }
                        if (spCell.isFormula() && !this.m_OutputAsDisplayed) {
                            cell.setCellFormula(spCell.getFormula().substring(1));
                            continue;
                        }
                        if (spCell.isDate()) {
                            cell.setCellValue(spCell.toDate());
                            cell.setCellStyle(styleDate);
                            continue;
                        }
                        if (spCell.isTime()) {
                            cell.setCellValue((Date)spCell.toTime());
                            cell.setCellStyle(styleTime);
                            continue;
                        }
                        if (spCell.isDateTime()) {
                            cell.setCellValue((Date)spCell.toDateTime());
                            cell.setCellStyle(styleDateTime);
                            continue;
                        }
                        if (spCell.isNumeric()) {
                            cell.setCellValue(Utils.toDouble((String)spCell.getContent()).doubleValue());
                            continue;
                        }
                        cell.setCellValue(spCell.getContent());
                    }
                }
                ++count;
            }
            workbook.write(out);
        }
        catch (Exception e) {
            result = false;
            this.getSystemErr().printStackTrace("Failed writing spreadsheet data", (Throwable)e);
        }
        return result;
    }
}

