/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.DateUtils;
import adams.data.conversion.AbstractSpreadSheetColumnConverter;
import adams.data.spreadsheet.Cell;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class ExcelDoubleColumnToDate
extends AbstractSpreadSheetColumnConverter {
    private static final long serialVersionUID = 8681800940519018023L;
    protected Calendar m_Calendar;
    protected Date m_StartDate;

    public String globalInfo() {
        return "Converts the specified double column to a date column.";
    }

    public String columnTipText() {
        return "The double column to convert to date; " + this.m_Column.getExample();
    }

    protected String checkData() {
        this.m_Calendar = new GregorianCalendar();
        this.m_StartDate = DateUtils.getDateFormatter().parse("1900-01-01");
        return super.checkData();
    }

    protected void convert(Cell cellOld, Cell cellNew) throws Exception {
        this.m_Calendar.setTime((Date)this.m_StartDate.clone());
        this.m_Calendar.add(6, cellOld.toDouble().intValue() - 1);
        cellNew.setContent(this.m_Calendar.getTime());
    }
}

