/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.DateFormat;
import adams.core.DateTime;
import adams.core.DateUtils;
import adams.core.Utils;
import adams.data.io.input.AbstractExcelSpreadSheetReader;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.output.ExcelSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelSpreadSheetReader
extends AbstractExcelSpreadSheetReader {
    private static final long serialVersionUID = 4755872204697328246L;

    public String globalInfo() {
        return "Reads MS Excel files (using DOM).";
    }

    public String getFormatDescription() {
        return "MS Excel spreadsheets";
    }

    public String[] getFormatExtensions() {
        return new String[]{"xls", "xlsx"};
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new ExcelSpreadSheetWriter();
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.STREAM;
    }

    protected String numericToString(Cell cell) {
        Double dbl = cell.getNumericCellValue();
        long lng = dbl.longValue();
        if (dbl == (double)lng) {
            return "" + lng;
        }
        return "" + dbl;
    }

    protected List<SpreadSheet> doReadRange(InputStream in) {
        ArrayList<SpreadSheet> result = new ArrayList<SpreadSheet>();
        Workbook workbook = null;
        DateFormat dformat = DateUtils.getTimestampFormatter();
        try {
            workbook = WorkbookFactory.create((InputStream)in);
            this.m_SheetRange.setMax(workbook.getNumberOfSheets());
            int[] indices = this.m_SheetRange.getIntIndices();
            int firstRow = this.m_FirstRow - 1;
            int dataRowStart = this.getNoHeader() ? firstRow : firstRow + 1;
            for (int index : indices) {
                boolean numeric;
                Cell exCell;
                int i;
                HeaderRow spRow;
                Row exRow;
                Sheet sheet;
                if (this.m_Stopped) break;
                SpreadSheet spsheet = this.m_SpreadSheetType.newInstance();
                spsheet.setDataRowClass(this.m_DataRowType.getClass());
                result.add(spsheet);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("sheet: " + (index + 1));
                }
                if ((sheet = workbook.getSheetAt(index)).getLastRowNum() == 0) {
                    this.getLogger().severe("No rows in sheet #" + index);
                    return null;
                }
                spsheet.setName(sheet.getSheetName());
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("header row");
                }
                if ((exRow = sheet.getRow(firstRow)) == null) {
                    this.getLogger().warning("No data in sheet #" + (index + 1) + "?");
                } else if (exRow != null) {
                    List header;
                    spRow = spsheet.getHeaderRow();
                    this.m_TextColumns.setMax((int)exRow.getLastCellNum());
                    if (this.getNoHeader()) {
                        header = SpreadSheetUtils.createHeader((int)exRow.getLastCellNum(), (String)this.m_CustomColumnHeaders);
                        for (i = 0; i < header.size(); ++i) {
                            spRow.addCell("" + (i + 1)).setContent((String)header.get(i));
                        }
                    } else if (!this.m_CustomColumnHeaders.trim().isEmpty()) {
                        header = SpreadSheetUtils.createHeader((int)exRow.getLastCellNum(), (String)this.m_CustomColumnHeaders);
                        for (i = 0; i < header.size(); ++i) {
                            spRow.addCell("" + (i + 1)).setContent((String)header.get(i));
                        }
                    } else {
                        block13: for (i = 0; i < exRow.getLastCellNum() && !this.m_Stopped; ++i) {
                            exCell = exRow.getCell(i);
                            if (exCell == null) {
                                spRow.addCell("" + (i + 1)).setMissing();
                                continue;
                            }
                            numeric = !this.m_TextColumns.isInRange(i);
                            switch (exCell.getCellType()) {
                                case 3: 
                                case 5: {
                                    spRow.addCell("" + (i + 1)).setContent("column-" + (i + 1));
                                    continue block13;
                                }
                                case 0: {
                                    if (HSSFDateUtil.isCellDateFormatted((Cell)exCell)) {
                                        spRow.addCell("" + (i + 1)).setContent(new DateTime(HSSFDateUtil.getJavaDate((double)exCell.getNumericCellValue())));
                                        continue block13;
                                    }
                                    if (numeric) {
                                        spRow.addCell("" + (i + 1)).setContent(Double.valueOf(exCell.getNumericCellValue()));
                                        continue block13;
                                    }
                                    spRow.addCell("" + (i + 1)).setContentAsString(this.numericToString(exCell));
                                    continue block13;
                                }
                                default: {
                                    spRow.addCell("" + (i + 1)).setContentAsString(exCell.getStringCellValue());
                                }
                            }
                        }
                    }
                }
                if (spsheet.getColumnCount() <= 0) continue;
                int lastRow = this.m_NumRows < 1 ? sheet.getLastRowNum() : Math.min(firstRow + this.m_NumRows - 1, sheet.getLastRowNum());
                for (i = dataRowStart; i <= lastRow && !this.m_Stopped; ++i) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("data row: " + (i + 1));
                    }
                    spRow = spsheet.addRow("" + spsheet.getRowCount());
                    exRow = sheet.getRow(i);
                    if (exRow == null) continue;
                    block15: for (int n = 0; n < exRow.getLastCellNum(); ++n) {
                        if (n >= spsheet.getHeaderRow().getCellCount() && this.m_AutoExtendHeader) {
                            spsheet.insertColumn(spsheet.getColumnCount(), "");
                        }
                        this.m_TextColumns.setMax(spsheet.getHeaderRow().getCellCount());
                        exCell = exRow.getCell(n);
                        if (exCell == null) {
                            spRow.addCell(n).setMissing();
                            continue;
                        }
                        int cellType = exCell.getCellType();
                        if (cellType == 2) {
                            cellType = exCell.getCachedFormulaResultType();
                        }
                        numeric = !this.m_TextColumns.isInRange(n);
                        switch (cellType) {
                            case 3: 
                            case 5: {
                                if (this.m_MissingValue.isEmpty()) {
                                    spRow.addCell(n).setMissing();
                                    continue block15;
                                }
                                spRow.addCell(n).setContent("");
                                continue block15;
                            }
                            case 0: {
                                if (HSSFDateUtil.isCellDateFormatted((Cell)exCell)) {
                                    spRow.addCell(n).setContent(dformat.format(HSSFDateUtil.getJavaDate((double)exCell.getNumericCellValue())));
                                    continue block15;
                                }
                                if (numeric) {
                                    spRow.addCell(n).setContent(Double.valueOf(exCell.getNumericCellValue()));
                                    continue block15;
                                }
                                spRow.addCell(n).setContentAsString(this.numericToString(exCell));
                                continue block15;
                            }
                            default: {
                                if (this.m_MissingValue.isMatch(exCell.getStringCellValue())) {
                                    spRow.addCell(n).setMissing();
                                    continue block15;
                                }
                                spRow.addCell(n).setContentAsString(exCell.getStringCellValue());
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ioe) {
            this.getLogger().log(Level.SEVERE, "Failed to read range '" + this.m_SheetRange + "':", (Throwable)ioe);
            result = null;
            this.m_LastError = "Failed to read range '" + this.m_SheetRange + "' from stream!\n" + Utils.throwableToString((Throwable)ioe);
        }
        return result;
    }
}

