/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.AbstractFileWriter;
import adams.flow.sink.ffmpeg.AbstractFFmpegPlugin;
import adams.flow.sink.ffmpeg.GenericPlugin;
import adams.flow.standalone.FFmpegConfig;
import java.io.File;

public class FFmpeg
extends AbstractFileWriter {
    private static final long serialVersionUID = -7106585852803101639L;
    protected AbstractFFmpegPlugin m_Plugin;
    protected transient FFmpegConfig m_Config;

    public String globalInfo() {
        return "Uses the specified plugin to perform an avconv/ffmpeg operation.";
    }

    protected void reset() {
        super.reset();
        this.m_Config = null;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("plugin", "plugin", (Object)new GenericPlugin());
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"plugin", (Object)((Object)this.m_Plugin), (String)", plugin: ");
        return result;
    }

    public void setPlugin(AbstractFFmpegPlugin value) {
        this.m_Plugin = value;
        this.m_Plugin.setOwner(this);
        this.reset();
    }

    public AbstractFFmpegPlugin getPlugin() {
        return this.m_Plugin;
    }

    public String pluginTipText() {
        return "The plugin to use.";
    }

    public String outputFileTipText() {
        return "The output file to generate.";
    }

    public Class[] accepts() {
        return new Class[]{File.class, String.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Config = (FFmpegConfig)ActorUtils.findClosestType((Actor)this, FFmpegConfig.class);
            if (this.m_Config == null) {
                result = "No " + FFmpegConfig.class.getName() + " actor found!";
            }
        }
        if (result == null) {
            result = this.m_Plugin.setUp();
        }
        return result;
    }

    public FFmpegConfig getConfig() {
        return this.m_Config;
    }

    protected String doExecute() {
        if (this.m_InputToken.getPayload() instanceof File) {
            this.m_Plugin.setInput(new PlaceholderFile((File)this.m_InputToken.getPayload()));
        } else {
            this.m_Plugin.setInput(new PlaceholderFile((String)this.m_InputToken.getPayload()));
        }
        return this.m_Plugin.execute();
    }
}

