/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.ffmpeg;

import adams.core.QuickInfoSupporter;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingSupporter;
import adams.core.management.ProcessUtils;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.sink.FFmpeg;
import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractFFmpegPlugin
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = -2555683041357914117L;
    protected FFmpeg m_Owner;
    protected PlaceholderFile m_Input;

    protected void initialize() {
        super.initialize();
        this.m_Owner = null;
    }

    protected void reset() {
        super.reset();
        this.m_Input = null;
    }

    public void setOwner(FFmpeg owner) {
        this.m_Owner = owner;
    }

    public FFmpeg getOwner() {
        return this.m_Owner;
    }

    public void setInput(PlaceholderFile value) {
        this.m_Input = value;
    }

    public PlaceholderFile getInput() {
        return this.m_Input;
    }

    protected PlaceholderFile getExecutable() {
        if (this.m_Owner == null || this.m_Owner.getConfig() == null) {
            return null;
        }
        return this.m_Owner.getConfig().getExecutable();
    }

    public String getQuickInfo() {
        return null;
    }

    public String setUp() {
        String result = null;
        if (this.m_Owner == null) {
            result = "No owner set!";
        }
        return result;
    }

    protected String handleException(String msg, Throwable t) {
        return Utils.handleException((LoggingSupporter)this, (String)msg, (Throwable)t);
    }

    protected abstract String assembleInputOptions();

    protected abstract String assembleOutputOptions();

    public String execute() {
        String result = null;
        if (this.m_Input == null) {
            result = "No input file set!";
        }
        if (result == null) {
            ArrayList<String> options = new ArrayList<String>();
            try {
                CollectingProcessOutput proc;
                options.add(this.getExecutable().getAbsolutePath());
                options.add("-y");
                String cmd = this.assembleInputOptions();
                if (cmd.length() > 0) {
                    options.addAll(Arrays.asList(OptionUtils.splitOptions((String)cmd)));
                }
                options.add("-i");
                options.add(this.m_Input.getAbsolutePath());
                cmd = this.assembleOutputOptions();
                if (cmd.length() > 0) {
                    options.addAll(Arrays.asList(OptionUtils.splitOptions((String)cmd)));
                }
                options.add(this.getOwner().getOutputFile().getAbsolutePath());
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Command-line: " + Utils.flatten(options, (String)" "));
                }
                if (!(proc = ProcessUtils.execute((String[])options.toArray(new String[options.size()]))).hasSucceeded()) {
                    result = ProcessUtils.toErrorOutput((CollectingProcessOutput)proc);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to execute commandline:\n" + Utils.flatten(options, (String)"\n"), e);
            }
        }
        this.m_Input = null;
        return result;
    }
}

