/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.ffmpeg;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.sink.ffmpeg.AbstractFFmpegPluginWithOptions;

public class ConvertAudio
extends AbstractFFmpegPluginWithOptions {
    private static final long serialVersionUID = -385408477332933453L;
    protected String m_Encoder;
    protected int m_BitRate;

    public String globalInfo() {
        return "Converts audio files.\nYou can use the following commandline to check the available encoders:\nffmpeg -encoders";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoder", "encoder", (Object)"pcm_s16le");
        this.m_OptionManager.add("bit-rate", "bitRate", (Object)44100, (Number)1, null);
    }

    public void setEncoder(String value) {
        this.m_Encoder = value;
        this.reset();
    }

    public String getEncoder() {
        return this.m_Encoder;
    }

    public String encoderTipText() {
        return "The encoder to use for the output audio file.";
    }

    public void setBitRate(int value) {
        this.m_BitRate = value;
        this.reset();
    }

    public int getBitRate() {
        return this.m_BitRate;
    }

    public String bitRateTipText() {
        return "The bit rate to use for the output file.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"encoder", (Object)this.m_Encoder, (String)", encoder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"bitRate", (Object)this.m_BitRate, (String)", bit-rate: ");
        return result;
    }

    @Override
    protected String assembleActualInputOptions() {
        return "";
    }

    @Override
    protected String assembleActualOutputOptions() {
        return "-acodec " + this.m_Encoder + " -ar " + this.m_BitRate;
    }
}

