/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.management.OS;
import adams.core.option.OptionHandler;
import adams.flow.standalone.AbstractStandalone;

public class FFmpegConfig
extends AbstractStandalone {
    private static final long serialVersionUID = -7106585852803101639L;
    protected PlaceholderFile m_Executable;

    public String globalInfo() {
        return "Defines the ffmpeg/avconv executable.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("executable", "executable", (Object)this.getDefaultExecutable());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"executable", (Object)this.m_Executable, (String)"executable: ");
    }

    protected PlaceholderFile getDefaultExecutable() {
        if (OS.isWindows()) {
            return new PlaceholderFile("ffmpeg.exe");
        }
        if (FileUtils.fileExists((String)"/usr/bin/ffmpeg")) {
            return new PlaceholderFile("/usr/bin/ffmpeg");
        }
        if (FileUtils.fileExists((String)"/usr/bin/avconv")) {
            return new PlaceholderFile("/usr/bin/avconv");
        }
        return new PlaceholderFile("/usr/bin/ffmpeg");
    }

    public void setExecutable(PlaceholderFile value) {
        this.m_Executable = value;
        this.reset();
    }

    public PlaceholderFile getExecutable() {
        return this.m_Executable;
    }

    public String executableTipText() {
        return "The avconv/ffmpeg executable.";
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null) {
            if (this.m_Executable.isDirectory()) {
                result = "Executable points to a directory: " + this.m_Executable;
            } else if (!this.m_Executable.exists()) {
                result = "Executable does not exist: " + this.m_Executable;
            }
        }
        return result;
    }

    protected String doExecute() {
        return null;
    }
}

