/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.gnuplot.AbstractScriptlet;
import adams.core.gnuplot.Initialize;
import adams.core.gnuplot.MultiScriptlet;
import adams.core.gnuplot.Pause;
import adams.core.gnuplot.SimplePlot;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.GnuplotScript;
import adams.flow.source.SingleFileSupplier;
import adams.test.Platform;
import adams.test.TmpFile;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;

public class GnuplotScriptTest
extends AbstractFlowTest {
    public GnuplotScriptTest(String name) {
        super(name);
    }

    protected HashSet<Platform> getPlatforms() {
        return new HashSet<Platform>(Arrays.asList(Platform.LINUX));
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv", "out.data");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.script");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("out.data");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.script");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.script")});
    }

    public static Test suite() {
        return new TestSuite(GnuplotScriptTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[2];
            SingleFileSupplier tmp2 = new SingleFileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("file");
            tmp2.setFile((PlaceholderFile)argOption.valueOf("${TMP}/out.data"));
            tmp1[0] = tmp2;
            GnuplotScript tmp4 = new GnuplotScript();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("outputFile");
            tmp4.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.script"));
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("scriptlet");
            MultiScriptlet tmp7 = new MultiScriptlet();
            argOption = (AbstractArgumentOption)tmp7.getOptionManager().findByProperty("scriptlets");
            AbstractScriptlet[] tmp8 = new AbstractScriptlet[4];
            Initialize tmp9 = new Initialize();
            argOption = (AbstractArgumentOption)tmp9.getOptionManager().findByProperty("title");
            tmp9.setTitle((String)argOption.valueOf("bolts dataset"));
            argOption = (AbstractArgumentOption)tmp9.getOptionManager().findByProperty("XLabel");
            tmp9.setXLabel((String)argOption.valueOf("target variable"));
            argOption = (AbstractArgumentOption)tmp9.getOptionManager().findByProperty("YLabel");
            tmp9.setYLabel((String)argOption.valueOf("input variables"));
            tmp8[0] = tmp9;
            SimplePlot tmp13 = new SimplePlot();
            argOption = (AbstractArgumentOption)tmp13.getOptionManager().findByProperty("columns");
            tmp13.setColumns((String)argOption.valueOf("8:2"));
            argOption = (AbstractArgumentOption)tmp13.getOptionManager().findByProperty("plotType");
            tmp13.setPlotType((SimplePlot.PlotType)argOption.valueOf("POINTS"));
            argOption = (AbstractArgumentOption)tmp13.getOptionManager().findByProperty("plotName");
            tmp13.setPlotName((String)argOption.valueOf("speed1 vs t20bolt"));
            tmp13.setFirstPlot(true);
            tmp8[1] = tmp13;
            SimplePlot tmp17 = new SimplePlot();
            argOption = (AbstractArgumentOption)tmp17.getOptionManager().findByProperty("columns");
            tmp17.setColumns((String)argOption.valueOf("8:7"));
            argOption = (AbstractArgumentOption)tmp17.getOptionManager().findByProperty("plotType");
            tmp17.setPlotType((SimplePlot.PlotType)argOption.valueOf("POINTS"));
            argOption = (AbstractArgumentOption)tmp17.getOptionManager().findByProperty("plotName");
            tmp17.setPlotName((String)argOption.valueOf("time vs t20bolt"));
            tmp8[2] = tmp17;
            Pause tmp21 = new Pause();
            argOption = (AbstractArgumentOption)tmp21.getOptionManager().findByProperty("waitingPeriod");
            tmp21.setWaitingPeriod(((Integer)argOption.valueOf("5")).intValue());
            argOption = (AbstractArgumentOption)tmp21.getOptionManager().findByProperty("message");
            tmp21.setMessage((String)argOption.valueOf("Press <Enter> to close the plot..."));
            tmp8[3] = tmp21;
            tmp7.setScriptlets(tmp8);
            tmp7.setUseSingleDataFile(true);
            tmp4.setScriptlet((AbstractScriptlet)tmp7);
            tmp1[1] = tmp4;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            GnuplotScriptTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GnuplotScriptTest.runTest((Test)GnuplotScriptTest.suite());
    }
}

