/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.Range;
import adams.core.Utils;
import adams.core.io.AbstractSpreadSheetWriter;
import adams.core.io.SpreadSheet;
import adams.env.Environment;
import java.io.Writer;
import java.util.Enumeration;

public class GnuplotSpreadSheetWriter
extends AbstractSpreadSheetWriter {
    private static final long serialVersionUID = -1298185600402768643L;
    public static final String COMMENT = "#";
    public static final String MISSING_VALUE = "-999";
    protected Range m_Columns;

    public String globalInfo() {
        return "Outputs all numeric columns of a spreadsheet in Gnuplot format.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Columns = new Range();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new Range("first-last"));
        this.m_OptionManager.add("invert", "invert", (Object)false);
    }

    public String getFormatDescription() {
        return "Gnuplot data";
    }

    public String[] getFormatExtensions() {
        return new String[]{"dat", "data"};
    }

    protected String getDefaultMissingValue() {
        return MISSING_VALUE;
    }

    public void setColumns(Range value) {
        this.m_Columns = value;
        this.reset();
    }

    public Range getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The columns in the spreadsheet to output.";
    }

    public void setInvert(boolean value) {
        this.m_Columns.setInverted(value);
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Columns.isInverted();
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    protected boolean getUseOutputStream() {
        return false;
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        boolean result = true;
        try {
            SpreadSheet.Cell cell;
            int i;
            String newline = System.getProperty("line.separator");
            this.m_Columns.setMax(content.getColumnCount());
            int[] indices = this.m_Columns.getIntIndices();
            boolean[] isNumeric = new boolean[indices.length];
            boolean first = true;
            for (i = 0; i < isNumeric.length; ++i) {
                isNumeric[i] = content.isNumeric(indices[i]);
                if (!isNumeric[i]) continue;
                first = false;
            }
            if (first) {
                return false;
            }
            writer.write("# Project: " + Environment.getInstance().getProject() + newline);
            writer.write("# User: " + System.getProperty("user.name") + newline);
            writer.write(COMMENT + newline);
            if (content.hasName()) {
                writer.write("# " + content.getName() + newline);
                writer.write(COMMENT + newline);
            }
            if (content.getComments().size() > 0) {
                for (i = 0; i < content.getComments().size(); ++i) {
                    writer.write("# " + (String)content.getComments().get(i) + newline);
                }
                writer.write(COMMENT + newline);
            }
            first = true;
            for (i = 0; i < indices.length; ++i) {
                cell = content.getHeaderRow().getCell(indices[i]);
                if (!isNumeric[i]) continue;
                if (first) {
                    writer.write("# ");
                } else {
                    writer.write("\t");
                }
                if (cell.isMissing()) {
                    writer.write(Utils.doubleQuote((String)this.m_MissingValue));
                } else {
                    writer.write(Utils.doubleQuote((String)cell.getContent()));
                }
                first = false;
            }
            writer.write(newline);
            SpreadSheet.Row header = content.getHeaderRow();
            Enumeration rowKeys = content.rowKeys();
            while (rowKeys.hasMoreElements()) {
                SpreadSheet.Row row = content.getRow((String)rowKeys.nextElement());
                first = true;
                for (i = 0; i < indices.length; ++i) {
                    String colName = header.getCellKey(indices[i]);
                    cell = row.getCell(colName);
                    if (!isNumeric[i]) continue;
                    if (!first) {
                        writer.write("\t");
                    }
                    if (cell != null && cell.getContent() != null && !cell.isMissing()) {
                        writer.write(Utils.doubleQuote((String)cell.getContent()));
                    } else {
                        writer.write(Utils.doubleQuote((String)this.m_MissingValue));
                    }
                    first = false;
                }
                writer.write(newline);
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }
}

