/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.gnuplot.AbstractScriptlet;
import adams.core.gnuplot.AbstractScriptletWithDataFile;
import adams.core.gnuplot.CustomScriptlet;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Actor;
import adams.flow.sink.AbstractAppendableFileWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

public class GnuplotScript
extends AbstractAppendableFileWriter {
    private static final long serialVersionUID = 7939417611957322357L;
    protected AbstractScriptlet m_Scriptlet;

    public String globalInfo() {
        return "Actor for generating Gnuplot script files for plotting data stored in the data file that is received as input.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("scriptlet", "scriptlet", (Object)new CustomScriptlet());
    }

    public String outputFileTipText() {
        return "The name of the Gnuplot script file.";
    }

    public String appendTipText() {
        return "If set to true, scripts gets only appended.";
    }

    public void setScriptlet(AbstractScriptlet value) {
        this.m_Scriptlet = value;
        this.m_Scriptlet.setOwner((Actor)this);
        this.reset();
    }

    public AbstractScriptlet getScriptlet() {
        return this.m_Scriptlet;
    }

    public String scriptletTipText() {
        return "The scriplet to use for producing the Gnuplot script for plotting the data.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    protected String doExecute() {
        PlaceholderFile file = this.m_InputToken.getPayload() instanceof String ? new PlaceholderFile((String)this.m_InputToken.getPayload()) : new PlaceholderFile((File)this.m_InputToken.getPayload());
        if (this.m_Scriptlet instanceof AbstractScriptletWithDataFile) {
            ((AbstractScriptletWithDataFile)this.m_Scriptlet).setDataFile(file);
        }
        String script = this.m_Scriptlet.generate();
        script = this.getVariables().expand(script);
        String result = this.m_Scriptlet.getLastError();
        if (result == null) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_OutputFile.getAbsolutePath(), this.m_Append));
                writer.write(script);
                writer.flush();
                writer.close();
                result = null;
            }
            catch (Exception e) {
                result = this.handleException("Failed to write script to: " + this.m_OutputFile, e);
            }
        }
        return result;
    }
}

