/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.VariableName;
import adams.core.base.BaseAnnotation;
import adams.core.base.BaseText;
import adams.core.gnuplot.AbstractScriptlet;
import adams.core.gnuplot.Initialize;
import adams.core.gnuplot.MultiScriptlet;
import adams.core.gnuplot.Pause;
import adams.core.gnuplot.SimplePlot;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.GnuplotSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Trigger;
import adams.flow.core.Actor;
import adams.flow.sink.GnuplotScript;
import adams.flow.sink.SpreadSheetFileWriter;
import adams.flow.source.FileSupplier;
import adams.flow.source.Start;
import adams.flow.source.Variable;
import adams.flow.standalone.Gnuplot;
import adams.flow.standalone.SetVariable;
import adams.flow.transformer.SpreadSheetFileReader;
import junit.framework.Test;
import junit.framework.TestSuite;

public class GnuplotTest
extends AbstractFlowTest {
    public GnuplotTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("bolts_plot.data");
        this.m_TestHelper.deleteFileFromTmp("bolts_plot.script");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("bolts_plot.data");
        this.m_TestHelper.deleteFileFromTmp("bolts_plot.script");
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(GnuplotTest.class);
    }

    public Actor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("annotations");
            flow.setAnnotations((BaseAnnotation)argOption.valueOf("This flow generates a Gnuplot script file for the \"bolts\" UCI dataset.\nIt then executes gnuplot (executable needs to be on the PATH).\nThe plot closes automatically after 5 seconds."));
            argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            Actor[] tmp2 = new Actor[6];
            SetVariable tmp3 = new SetVariable();
            argOption = (AbstractArgumentOption)tmp3.getOptionManager().findByProperty("name");
            tmp3.setName((String)argOption.valueOf("SetVariable (data)"));
            argOption = (AbstractArgumentOption)tmp3.getOptionManager().findByProperty("variableName");
            tmp3.setVariableName((VariableName)argOption.valueOf("data_file"));
            argOption = (AbstractArgumentOption)tmp3.getOptionManager().findByProperty("variableValue");
            tmp3.setVariableValue((BaseText)argOption.valueOf("${TMP}/bolts_plot.data"));
            tmp2[0] = tmp3;
            SetVariable tmp7 = new SetVariable();
            argOption = (AbstractArgumentOption)tmp7.getOptionManager().findByProperty("name");
            tmp7.setName((String)argOption.valueOf("SetVariable (script)"));
            argOption = (AbstractArgumentOption)tmp7.getOptionManager().findByProperty("variableName");
            tmp7.setVariableName((VariableName)argOption.valueOf("script_file"));
            argOption = (AbstractArgumentOption)tmp7.getOptionManager().findByProperty("variableValue");
            tmp7.setVariableValue((BaseText)argOption.valueOf("${TMP}/bolts_plot.script"));
            tmp2[1] = tmp7;
            Start tmp11 = new Start();
            tmp2[2] = tmp11;
            Trigger tmp12 = new Trigger();
            argOption = (AbstractArgumentOption)tmp12.getOptionManager().findByProperty("name");
            tmp12.setName((String)argOption.valueOf("generate data file"));
            argOption = (AbstractArgumentOption)tmp12.getOptionManager().findByProperty("actors");
            Actor[] tmp14 = new Actor[3];
            FileSupplier tmp15 = new FileSupplier();
            argOption = (AbstractArgumentOption)tmp15.getOptionManager().findByProperty("files");
            tmp15.setFiles(new PlaceholderFile[]{(PlaceholderFile)argOption.valueOf("${TMP}/bolts.csv")});
            tmp14[0] = tmp15;
            SpreadSheetFileReader tmp17 = new SpreadSheetFileReader();
            argOption = (AbstractArgumentOption)tmp17.getOptionManager().findByProperty("reader");
            CsvSpreadSheetReader tmp19 = new CsvSpreadSheetReader();
            tmp17.setReader((SpreadSheetReader)tmp19);
            tmp14[1] = tmp17;
            SpreadSheetFileWriter tmp20 = new SpreadSheetFileWriter();
            argOption = (AbstractArgumentOption)tmp20.getOptionManager().findByProperty("outputFile");
            argOption.setVariable("@{data_file}");
            argOption = (AbstractArgumentOption)tmp20.getOptionManager().findByProperty("writer");
            GnuplotSpreadSheetWriter tmp22 = new GnuplotSpreadSheetWriter();
            tmp20.setWriter((SpreadSheetWriter)tmp22);
            tmp14[2] = tmp20;
            tmp12.setActors(tmp14);
            tmp2[3] = tmp12;
            Trigger tmp23 = new Trigger();
            argOption = (AbstractArgumentOption)tmp23.getOptionManager().findByProperty("name");
            tmp23.setName((String)argOption.valueOf("generate script file"));
            argOption = (AbstractArgumentOption)tmp23.getOptionManager().findByProperty("actors");
            Actor[] tmp25 = new Actor[2];
            Variable tmp26 = new Variable();
            argOption = (AbstractArgumentOption)tmp26.getOptionManager().findByProperty("variableName");
            tmp26.setVariableName((VariableName)argOption.valueOf("data_file"));
            tmp25[0] = tmp26;
            GnuplotScript tmp28 = new GnuplotScript();
            argOption = (AbstractArgumentOption)tmp28.getOptionManager().findByProperty("outputFile");
            argOption.setVariable("@{script_file}");
            argOption = (AbstractArgumentOption)tmp28.getOptionManager().findByProperty("scriptlet");
            MultiScriptlet tmp30 = new MultiScriptlet();
            argOption = (AbstractArgumentOption)tmp30.getOptionManager().findByProperty("scriptlets");
            AbstractScriptlet[] tmp31 = new AbstractScriptlet[4];
            Initialize tmp32 = new Initialize();
            argOption = (AbstractArgumentOption)tmp32.getOptionManager().findByProperty("title");
            tmp32.setTitle((String)argOption.valueOf("bolts dataset"));
            argOption = (AbstractArgumentOption)tmp32.getOptionManager().findByProperty("XLabel");
            tmp32.setXLabel((String)argOption.valueOf("target variable"));
            argOption = (AbstractArgumentOption)tmp32.getOptionManager().findByProperty("YLabel");
            tmp32.setYLabel((String)argOption.valueOf("input variables"));
            tmp31[0] = tmp32;
            SimplePlot tmp36 = new SimplePlot();
            argOption = (AbstractArgumentOption)tmp36.getOptionManager().findByProperty("columns");
            tmp36.setColumns((String)argOption.valueOf("8:2"));
            argOption = (AbstractArgumentOption)tmp36.getOptionManager().findByProperty("plotType");
            tmp36.setPlotType((SimplePlot.PlotType)argOption.valueOf("POINTS"));
            argOption = (AbstractArgumentOption)tmp36.getOptionManager().findByProperty("plotName");
            tmp36.setPlotName((String)argOption.valueOf("speed1 vs t20bolt"));
            tmp36.setFirstPlot(true);
            tmp31[1] = tmp36;
            SimplePlot tmp40 = new SimplePlot();
            argOption = (AbstractArgumentOption)tmp40.getOptionManager().findByProperty("columns");
            tmp40.setColumns((String)argOption.valueOf("8:7"));
            argOption = (AbstractArgumentOption)tmp40.getOptionManager().findByProperty("plotType");
            tmp40.setPlotType((SimplePlot.PlotType)argOption.valueOf("POINTS"));
            argOption = (AbstractArgumentOption)tmp40.getOptionManager().findByProperty("plotName");
            tmp40.setPlotName((String)argOption.valueOf("time vs t20bolt"));
            tmp31[2] = tmp40;
            Pause tmp44 = new Pause();
            argOption = (AbstractArgumentOption)tmp44.getOptionManager().findByProperty("waitingPeriod");
            tmp44.setWaitingPeriod(((Integer)argOption.valueOf("1")).intValue());
            argOption = (AbstractArgumentOption)tmp44.getOptionManager().findByProperty("message");
            tmp44.setMessage((String)argOption.valueOf("Press <Enter> to close the plot..."));
            tmp31[3] = tmp44;
            tmp30.setScriptlets(tmp31);
            tmp30.setUseSingleDataFile(true);
            tmp28.setScriptlet((AbstractScriptlet)tmp30);
            tmp25[1] = tmp28;
            tmp23.setActors(tmp25);
            tmp2[4] = tmp23;
            Trigger tmp47 = new Trigger();
            argOption = (AbstractArgumentOption)tmp47.getOptionManager().findByProperty("name");
            tmp47.setName((String)argOption.valueOf("execute gnuplot"));
            argOption = (AbstractArgumentOption)tmp47.getOptionManager().findByProperty("actors");
            Actor[] tmp49 = new Actor[1];
            Gnuplot tmp50 = new Gnuplot();
            argOption = (AbstractArgumentOption)tmp50.getOptionManager().findByProperty("scriptFile");
            argOption.setVariable("@{script_file}");
            tmp49[0] = tmp50;
            tmp47.setActors(tmp49);
            tmp2[5] = tmp47;
            flow.setActors(tmp2);
        }
        catch (Exception e) {
            GnuplotTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GnuplotTest.runTest((Test)GnuplotTest.suite());
    }
}

