/*
 * Decompiled with CFR 0.152.
 */
package adams.core.gnuplot;

import adams.core.gnuplot.AbstractScriptlet;
import adams.core.io.AbsolutePathSupporter;
import adams.core.io.PlaceholderFile;

public abstract class AbstractScriptletWithDataFile
extends AbstractScriptlet
implements AbsolutePathSupporter {
    private static final long serialVersionUID = 8269710957096517396L;
    protected PlaceholderFile m_DataFile;
    protected boolean m_UseAbsolutePath;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-file", "dataFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("use-absolute-path", "useAbsolutePath", (Object)true);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_LastError = null;
    }

    public void setDataFile(PlaceholderFile value) {
        this.m_DataFile = value;
        this.reset();
    }

    public PlaceholderFile getDataFile() {
        return this.m_DataFile;
    }

    public String dataFileTipText() {
        return "The data file to use as basis for the plot.";
    }

    public void setUseAbsolutePath(boolean value) {
        this.m_UseAbsolutePath = value;
        this.reset();
    }

    public boolean getUseAbsolutePath() {
        return this.m_UseAbsolutePath;
    }

    public String useAbsolutePathTipText() {
        return "If enabled, the absolute path of the data file is used, otherwise just its name.";
    }

    public String getActualDataFile() {
        if (this.m_UseAbsolutePath) {
            return this.getDataFile().getAbsolutePath();
        }
        return this.getDataFile().getName();
    }

    @Override
    public String check() {
        if (!this.m_DataFile.exists()) {
            return "Data file '" + this.m_DataFile + "' does not exist!";
        }
        if (!this.m_DataFile.isFile()) {
            return "'" + this.m_DataFile + "' is not a file?";
        }
        return null;
    }
}

