/*
 * Decompiled with CFR 0.152.
 */
package adams.core.gnuplot;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.gnuplot.AbstractScriptlet;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;

public class Initialize
extends AbstractScriptlet {
    private static final long serialVersionUID = -3540923217777778401L;
    public static final String TERMINAL_X11 = "x11";
    protected String m_Terminal;
    protected PlaceholderFile m_OutputFile;
    protected String m_Title;
    protected String m_XLabel;
    protected String m_YLabel;
    protected String m_ZLabel;

    public String globalInfo() {
        return "Initializes the plotting.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("terminal", "terminal", (Object)TERMINAL_X11);
        this.m_OptionManager.add("output", "outputFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("title", "title", (Object)"");
        this.m_OptionManager.add("x-label", "XLabel", (Object)"");
        this.m_OptionManager.add("y-label", "YLabel", (Object)"");
        this.m_OptionManager.add("z-label", "ZLabel", (Object)"");
    }

    public void setTerminal(String value) {
        this.m_Terminal = value;
        this.reset();
    }

    public String getTerminal() {
        return this.m_Terminal;
    }

    public String terminalTipText() {
        return "The terminal to use: e.g., 'x11', 'gif', 'png', 'svg'; for any terminal type apart from 'x11', an output file needs to be supplied.";
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The output file to use if terminal other than 'x11' is used.";
    }

    public void setTitle(String value) {
        this.m_Title = value;
        this.reset();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String titleTipText() {
        return "The title to use for the plot.";
    }

    public void setXLabel(String value) {
        this.m_XLabel = value;
        this.reset();
    }

    public String getXLabel() {
        return this.m_XLabel;
    }

    public String XLabelTipText() {
        return "The title for the X axis; gets ignored if empty.";
    }

    public void setYLabel(String value) {
        this.m_YLabel = value;
        this.reset();
    }

    public String getYLabel() {
        return this.m_YLabel;
    }

    public String YLabelTipText() {
        return "The title for the Y axis; gets ignored if empty.";
    }

    public void setZLabel(String value) {
        this.m_ZLabel = value;
        this.reset();
    }

    public String getZLabel() {
        return this.m_ZLabel;
    }

    public String ZLabelTipText() {
        return "The title for the Z axis; gets ignored if empty.";
    }

    @Override
    public String check() {
        Object result = super.check();
        if (result == null && !this.m_Terminal.equals(TERMINAL_X11) && !this.m_OutputFile.isDirectory()) {
            result = "Output '" + this.m_OutputFile + "' is pointing to a directory!";
        }
        return result;
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"title", (Object)this.m_Title, (String)"title: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"XLabel", (Object)this.m_XLabel, (String)", x-label: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"YLabel", (Object)this.m_YLabel, (String)", y-label: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"ZLabel", (Object)this.m_ZLabel, (String)", z-label: ");
        return result;
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        result.append("set term " + this.m_Terminal + "\n");
        if (!this.m_Terminal.equals(TERMINAL_X11)) {
            result.append("set output \"" + this.m_OutputFile.getAbsolutePath() + "\"\n");
        }
        if (this.m_Title.length() > 0) {
            result.append("set title \"" + Utils.backQuoteChars((String)this.m_Title) + "\"\n");
        }
        if (this.m_XLabel.length() > 0) {
            result.append("set xlabel \"" + Utils.backQuoteChars((String)this.m_XLabel) + "\"\n");
        }
        if (this.m_YLabel.length() > 0) {
            result.append("set ylabel \"" + Utils.backQuoteChars((String)this.m_YLabel) + "\"\n");
        }
        if (this.m_ZLabel.length() > 0) {
            result.append("set zlabel \"" + Utils.backQuoteChars((String)this.m_ZLabel) + "\"\n");
        }
        result.append("clear\n");
        return result.toString();
    }
}

