/*
 * Decompiled with CFR 0.152.
 */
package adams.core.gnuplot;

import adams.core.QuickInfoHelper;
import adams.core.gnuplot.AbstractScriptlet;
import adams.core.gnuplot.AbstractScriptletWithDataFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;

public class MultiScriptlet
extends AbstractScriptletWithDataFile {
    private static final long serialVersionUID = 6639840731369734498L;
    protected AbstractScriptlet[] m_Scriptlets;
    protected boolean m_UseSingleDataFile;

    public String globalInfo() {
        return "Allows the user to chain multiple scriplets together.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("scriptlet", "scriptlets", (Object)new AbstractScriptlet[0]);
        this.m_OptionManager.add("use-single-data-file", "useSingleDataFile", (Object)false);
    }

    @Override
    public void setOwner(Actor value) {
        super.setOwner(value);
        for (AbstractScriptlet scriptlet : this.m_Scriptlets) {
            scriptlet.setOwner(this.getOwner());
        }
    }

    public void setScriptlets(AbstractScriptlet[] value) {
        this.m_Scriptlets = value;
        this.setOwner(this.getOwner());
        this.reset();
    }

    public AbstractScriptlet[] getScriptlets() {
        return this.m_Scriptlets;
    }

    public String scriptletsTipText() {
        return "The scriplets to use for producing a single script.";
    }

    public void setUseSingleDataFile(boolean value) {
        this.m_UseSingleDataFile = value;
        this.reset();
    }

    public boolean getUseSingleDataFile() {
        return this.m_UseSingleDataFile;
    }

    public String useSingleDataFileTipText() {
        return "If enabled, all sub-scriptlets get automatically updated to use this scriptlets data file.";
    }

    @Override
    public String check() {
        String result = super.check();
        if (result == null) {
            int i;
            if (this.m_UseSingleDataFile) {
                for (i = 0; i < this.m_Scriptlets.length; ++i) {
                    if (!(this.m_Scriptlets[i] instanceof AbstractScriptletWithDataFile)) continue;
                    ((AbstractScriptletWithDataFile)this.m_Scriptlets[i]).setDataFile(this.getDataFile());
                }
            }
            for (i = 0; i < this.m_Scriptlets.length && (result = this.m_Scriptlets[i].check()) == null; ++i) {
            }
        }
        return result;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"scriptlets", (Object)this.m_Scriptlets, (String)"scriptlets: ");
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.m_Scriptlets.length; ++i) {
            result.append("# " + ((Object)((Object)this.m_Scriptlets[i])).getClass().getName() + "\n");
            result.append(this.m_Scriptlets[i].generate());
            result.append("\n");
        }
        return result.toString();
    }
}

